import dash_daq as daq
from dash import html, dcc
from pandas.api.types import is_numeric_dtype
import dash_bootstrap_components as dbc
from datetime import datetime
import dateutil.parser
import pandas as pd

def single_datetime_filter_picker(date, start_end=True):
    if isinstance(date, str):
        date = dateutil.parser.parse(date)
    if start_end:
        date = date - pd.Timedelta(seconds=1)
    else:
        date = date + pd.Timedelta(seconds=1)
    date = date.strftime('%Y-%m-%dT%H:%M:%S')
    return dbc.Input(value=date,
                     type='datetime-local',
                     id=("start" if start_end else "end") + "-date-filter",
                     step='1',
                     size='sm',
                     style={'border-color': '#cccccc',
                            'outline': '#cccccc',
                            'height': '24px',
                            'font-size': '12px',
                            'border-radius': 0},
                    persistence=False)

def contained_intersecting(intersecting):
    return daq.BooleanSwitch(id='contained-intersecting',
                             on=intersecting,
                             color='#abe2fb',
                             persistence=False,
                             style={'float': 'left'})

def start_step(start_end_df, start_steps):
    return dcc.Dropdown(id='start-step',
                         options=[
       {'label': start, 'value': start}
    for start in start_end_df[start_end_df['start_end']=='start']['step']],
                         value=start_steps,
                         multi=True,
                         persistence=False,
                       style={'font-size': '12px',
                            'border-radius': 0})

def end_step(start_end_df, end_steps):
    return dcc.Dropdown(id='end-step',
                 options=[
        {'label': end, 'value': end}
        for end in start_end_df[start_end_df['start_end']=='end']['step']],
                         value=end_steps,
                         multi=True,
                         persistence=False,
                       style={'font-size': '12px',
                            'border-radius': 0})

def case_performance_slider(case_performance):
    return dbc.Col([dbc.Row(dcc.RangeSlider(min=0, 
                        max=100, 
                        step=1,
                        value=case_performance,
                        marks=None,
                        allowCross=False,
                        id='case-performance-filter',
                        persistence=False),
                        style={'margin': 0, 'padding-top': '5px', 
                               'z-index': '-1'}),
                     dbc.Row([dbc.Col(html.Div(id='min-traces-duration'), style={'margin': 0, 'padding': 0}, md=2),
                     dbc.Col(html.Div(), md=8), dbc.Col(html.Div(id='max-traces-duration'), style={'margin': 0, 'padding': 0, 'float': 'right'}, md=2)],
                            style={'margin-top': 0, 'margin-left': '20px', 'padding-right': '40px', 'position': 'absolute', 'top': '18px', 'width': '100%'})],
                  style={'position': 'relative'})

def filter_title(title):
    return html.P(title, style={'margin-bottom': '0'})

def filter_element(title, element):
    return dbc.Container([
           dbc.Col([filter_title(title)], style={'padding-left': 0, 'margin-top': '4px', 'margin-bottom': '4px'}),
           dbc.Col(element, style={'margin': 0, 'padding-right': 0})], style={'margin': 0, 
                                                                              'margin-bottom': '4px',
                                                                              'margin-top': '4px',
                                                                              'padding': 0})

def filter_element_toggle(title, element):
    return dbc.Row([
        dbc.Col(element, style={'margin': 0, 'padding-left': 0}, md=3),
        dbc.Col([filter_title(title)], md=9, style={'padding-right': 0, 'padding-left': 0, 'margin-top': '4px', 'margin-bottom': '4px'})], 
        style={'margin': 0, 
              'margin-bottom': '4px',
              'margin-top': '4px',
              'padding': 0})

def filter_element_range(title, element):
    return dbc.Row([
        dbc.Col([filter_title(title)], md=4, style={'padding-left': 0, 'margin-top': '4px', 'margin-bottom': '4px'}), 
        dbc.Col(element, style={'margin': 0, 'padding-right': 0, 'padding-left': 0}, md=8)],
        style={'margin': 0, 
              'margin-bottom': '4px',
              'margin-top': '4px',
              'padding': 0})
