The event log dataset used as input to the Solution should contain the following columns:

| Column Type         | Purpose                                                                                  |
| ------------------- | ---------------------------------------------------------------------------------------- |
| **Case ID**         | Unique identifier for each process instance.                                              |
| **Activity**        | The name of each step in the process. Depending on the use case, it can be interpreted as an action, a state, or a mix of both. |
| **Timestamp**       | When the activity started.                                                                |
| **End Timestamp**   | (Optional) Enables idle time vs. processing time split. Should be greater than the **Timestamp** value of the same row, and smaller than that of the next activity for the same process instance. |
| **Sorting**  | (Optional) Breaks ties between activities with identical timestamps (e.g. `sequence_id`). |
| **Case Attributes** | (Optional) Useful for dashboard filters and segmentation. This can only be columns that weren't used above. |

Case Attributes are a great way to enrich the analysis. Examples:

- Loan application process: loan amount, loan type.
- Accounts payable process: invoice amount, supplier type.

Resource Attributes at the event level (e.g. who performed the activity) are not leveraged by the solution out of the box.
