_This article is targeted at end-users of the Process Mining application._

The [Process Mining](dashboard:lngA9Pv) dashboard's **Process Explorer** is a discovery and monitoring tool for process executions. It enables tracking key performance indicators (KPIs) such as average execution time and provides a visual breakdown of performance across activities. This helps pinpoint inefficiencies and anomalies within the process.

![Process Explorer.png](voECMYQ5ebxE)

# Filters

The Process Explorer metrics and charts can be filtered using case and process execution attributes:

- `timestamp_start`: The start time of the process execution.
- `activity_start`: The first activity in the process execution.
- `activity_end`: The last activity in the process execution.
- `variant_rank`: See [Filtering by Variant Rank](#filtering-by-variant-rank-1).
- `activities`: The number of activities in the process execution.
- `execution_time`: The total time taken to complete the process execution.
- `conformance`: See [Conformance](#conformance-1).

You can share a filtered view by clicking on the top icon of the **Filters** interface (three vertical dots) and selecting **Copy URL**.

# Metrics

- **Cases**: The number of cases matching the filters.
- **Variants**: The number of unique sequences of activities (variants) observed in cases matching the filters.
- **Average Execution Time**: The mean execution time of filtered cases, displayed in days.

# Process Graph

The **Process Graph** visualizes process variants—i.e., sequences of activities—similar to a traditional flowchart:

- **Nodes** represent activities observed in process data.
- **Arrows** depict transitions between activities.
- **Start and End nodes** (colored black) represent the beginning and conclusion of executions.

Unlike static flowcharts, the Process Graph is dynamically generated from process data and enriched with execution insights:

- **Top Variants**: Only the most frequent variants are displayed to highlight inefficiencies and anomalies (default: top 5).
- **Frequency View**: Displays the number of cases following each transition.
- **Time View**: Shows the time taken between activities.

The thickness of arrows and color intensity of nodes correspond to their respective values.

## Frequency View

- **Arrow values**: The number of times a transition occurs in process data. In practice, this is similar to the number of cases that went through this transition, but it can be higher if cases go through loops.
- **Node values**: The total occurrences of an activity (sum of incoming arrow values).
- **Color legend**: Represents the proportion of cases displayed (i.e. whose executions are in the top variants) relative to total cases matching filters.

Example (based on the screenshot above):

- Cases matching filters: **8,943**
- Total variants: **285**
- Displayed top 5 variants cover **7,457** cases (~83%).

## Time View

Interpretation depends on whether the original process data included both start and end times for activities.

### With End Times

- **Arrow values**: Duration between the end of one activity and the start of the next.
- **Node values**: Average duration between an activity’s start and end.

![time-view.png](NVzt1SOGThcV)

### Without End Times

- **Arrow values**: Average time between the start of successive activities.
- **Node values**: Computed as the mean of incoming arrow values.

## Export as PNG

To export the Process Graph as a PNG file:

1. Click the top-right icon.
2. Enter a file name and save.
3. The file is stored in the [saved_viz](managed_folder:LsTJHTYd) folder for download.

> If a file with the same name exists, it will be overwritten.

## Advanced Features

### Statistics

#### Transitions

Clicking a transition displays a popup with:

- Total occurrences across all executions.
- Minimum, average, and maximum transition time.

In **Time View**, the transition time displayed in the popup is computed across all executions, whereas the value next to the arrow reflects filtered cases.

![popup-transition.png](vcfNaz9fmJc8)

#### Activities

Clicking an activity displays:

- Total occurrences across all executions.
- The most likely predecessor and successor activities.

![popup-activity.png](LqgVZQCkqIJO)

### Exporting Process Data for Further Analysis

From transition and activity popups, you can export process data for all cases containing the selected transition or activity by clicking **Export dataset**. This is useful for conducting root cause analysis using advanced analytical tools. Choose a name to save the dataset, and share this name with your admin or with a data expert for further analysis.

### Conformance

The **Conformance** tab in the Process Graph evaluates adherence to a _reference process model_, helping to identify deviations and monitor compliance.

Each execution receives a **conformance score** between 0 and 1, which can be used as a filter.

> Ensure a reference process model is validated by your admin. By default, conformance is assessed against the top 5 variants. See [Saving a Reference Process Model](#saving-a-reference-process-model-1) to modify this.

The reference process model consists of **reference variants** (acceptable sequences from start to end). A special meta-activity, **SINK**, represents points where executions deviate:

- **Arrows to SINK**: Indicate cases that diverge from the reference model.
- **Frequency View**: Highlights the most common sources of non-conformance, via the thickness of arrows pointing to SINK.

![Conformance Tab.png](7esy4RcMzEzZ)

Note that all cases matching the Filters are represented in this visualization, whereas the Top Variants tab was showing a subset of these cases.

### Saving a Reference Process Model

To save a new reference model from the **Top Variants** tab:

1. Adjust filters (e.g., execution time) and the number of top variants to isolate desired variants.
2. Click **Save as Reference Model** in the top right corner.
3. Notify your admin to validate and apply the update. This will impact the Conformance graph and the conformance values shown in the Case Explorer.

If filtering alone doesn't isolate the correct reference variants, consult your admin for alternative methods.

### Filtering by Variant Rank

Each case is an instance of a variant, with a rank based on its frequency in the process data. To analyze additional anomalous patterns, adjust the `variant_rank` filter:

- If you've reviewed the **top 5 variants**, set `variant_rank` to **6** and keep the **top variants display** at **5**.
- This focuses on variants ranked **6 to 10**.

# Next: Case Explorer

The **Case Explorer** identifies execution outliers based on time and conformance score, enabling a deeper examination of individual cases.
