<span id="version" style="color: grey; float: right">Version 1.4.1</span>

# About this wiki

This wiki contains the technical documentation on how to use the Process Mining solution on a new process, and how the solution works.

- The two pages dedicated to the Process Mining dashboard are targeted at **business users** (process analysts, process owners): [Process Explorer](article:13) and [Case Explorer](article:15).
- The rest of this wiki is targeted at **data analysts/engineers/scientists**.

# What is Process Mining?

[Process Mining](https://en.wikipedia.org/wiki/Process_mining) is a set of techniques used to analyze event logs in order to better understand how processes actually unfold in practice. These logs can come from manual actions (e.g. task completion), automated system tasks (e.g. alert generation), or external inputs (e.g. a customer request). They are typically large, messy, and too complex to decipher without the right tools.

![Process Graph.png](3KfaPId8Txf8)

**Dataiku Process Mining** tackles this with two main capabilities:

- **Interactive Process Graph**
  - Visualizes process variants (i.e. different sequences of activities) in a flowchart-like format.
  - Built dynamically from process data and enriched with execution metrics.
  - Focuses on the most frequent variants to surface inefficiencies and anomalies fast.
  - More details in the [Process Explorer](article:13) page.
- **Conformance Scoring**
  - Measures how closely each execution follows a defined reference process model.
  - Helps pinpoint deviations, non-compliance, and broken workflows.
  - Individual scores can be used to filter the Process Graph and zoom in on problematic cases.
  - Average scores can be used to assess overall process health.
  - Conformance focuses on activity sequences, not timing.
  - More on this in the [Conformance Scoring](article:35) page.

These capabilities are integrated into **Dataiku Dashboards**, alongside filters, KPIs, charts, and data tables—everything needed to go from raw logs to actionable insight.

# Walkthrough

See [Case Study and Walkthrough](article:1), which lays out the typical steps to analyze a process using Process Mining in Dataiku. It’s based on a real use case and links out to in-depth documentation at each stage.
