The [Data Quality](dashboard:8P5Kcbo) dashboard helps check that your process data is as expected.

# Metrics

- **Dropped Cases** should be 0:
  - Cases are dropped from the analysis when they have several activities at the same timestamp.
  - When this happens, we cannot determine the order of these activities.
  - One way to fix this is by providing a sorting column when configuring the Process Mining instance.
  - See [Workflow Cleaning Zone](https://design.solutions.dataiku-dss.io/projects/SOL_PROCESS_MINING/wiki/16/Workflow%20Cleaning%20Zone) for more information.
- **Cases** should be 10-100x **Variants**:
  - First of all, make sure that the number of Cases makes sense based on the period of time you are analyzing.
  - If the number of variants is too high compared to the number of cases, the transitions you observe in the Process Graph will be supported by very few cases. You will have difficulties extracting strong patterns that are representative of the process.
  - The number of Variants grows exponentially with the number of Distinct Activities. The latter can be reduced by grouping activities that are too specific.

# Charts

- **Start/End Activities** pie charts allow to review start and end activities and their distributions. If you see activities which are not supposed to be start or end activities, it could mean that:
  - You are missing the first few activities of some process executions. This could happen if you have a cutoff date in your data.
  - Some executions are still ongoing.
- **Activity Frequency** helps review activity names, starting from the most frequent, and confirm that they are what we expect to see in a process visualization.
  - Confirm that no key activities are missing.
  - Detect if some activity names are too specific and should be grouped.
- **Total Time Spent per Activity** helps detect activities that are not so frequent but are time-consuming overall. It provides a first way to identify bottlenecks in the process.

All charts are interactive: hovering over a slice or a bar will display a tooltip with more information and filter buttons.

# Next Steps

Review and customize the charts in the [Process Mining](dashboard:lngA9Pv) dashboard's **Process Explorer**.
