The Process Graph found in the Process Mining dashboard has a button that saves variants currently displayed as the reference process model.

Before using this, you would need to set filters to focus the Process Graph on reference variants only. If this is challenging, we recommend adding a **Reference** column to your event log dataset and filtering the Process Explorer on `True` values.

Let's discuss how to set the values in this column. A reference process is a collection of reference variants, which are sequences of activities...

- If it's convenient to identify case IDs for all reference variants, you could set **Reference** to `True` for all rows of the event log matching these case IDs. This can be done with the "Create if, then, else statements" processor of a Prepare recipe in your process data preparation project.
- Alternatively, you could create "mock" event logs:
  - For each reference variant (sequence of activities):
    - Create a mock event log as a new Excel or CSV file.
    - Choose a mock value for the case ID and a start timestamp.
    - For each activity in the sequence, create a new entry (row) in the mock event log with:
      - The `reference` column set to True;
      - The name of the activity;
      - The chosen case ID;
      - An incremented timestamp (this is to make sure that timestamps are set in a way that matches the order of activities).
  - Finally, you would stack the mock event logs to the actual event log dataset in your process data preparation project, and use its output as the input to the Process Mining solution.