# How it works

Conformance scoring measures how closely each process execution follows a reference process model. The result is a score between 0 and 1—where 1 means a perfect match. The implementation can vary depending on business requirements.

In this Solution, the **reference model** is defined by a set of **reference variants**: execution paths that are considered acceptable. Each variant is a sequence of activities, represented as a comma-separated string of activity names.  
→ Learn more about [Representing reference variants in the event log](article:34).

For each case (i.e., each process execution), the conformance score is computed as the **maximum similarity** between:

- The actual activity sequence of the case.
- Each of the reference variants.

This similarity is calculated using the [Needleman–Wunsch algorithm](https://en.wikipedia.org/wiki/Needleman%E2%80%93Wunsch_algorithm), a dynamic programming method for sequence alignment. It evaluates how well two sequences match, accounting for:

- **Matches** (same activity in the same position),
- **Mismatches** (different activity),
- **Gaps** (missing or extra activities).

This produces a distance metric, which is then normalized into a score between 0 and 1.

# Other Types of Conformance

The default conformance scoring above only evaluates **activity sequences**—from start to end. But depending on the use case, other dimensions of conformance may be relevant:

## Time-Based Conformance

- Raise alerts when total process duration exceeds a defined threshold.
- Flag cases where the time between two specific activities (i.e. transition time) exceeds business-defined limits or deviates from statistical norms in the event log.

## Contextual or Resource-Based Conformance

- Check if all activities were performed by the same resource (e.g., person or business unit).
- Validate geography-based constraints: for example, ensure activities occur in a logical regional order, avoid repeated back-and-forth movements, or detect excessive detours based on location metadata in the log.