import axios from "../ApiHelper";


export let API = {
    getApplicationManifest: () => {
        console.log("Retrieving application manifest data ...");
        return axios.get("/api/get_application_manifest");
    },
    getWebappInitialResult: () => {
        console.log("Getting initial result ...");
        return axios.get("/api/get_webapp_initial_result");
    },
    getItemPictureBytes: function getItemPictureBytes(item_id) {
        console.log("Getting item picture bytes ...");
        return axios.get(`/api/get_item_picture_bytes/${item_id}`)
    },
    postWebappSettings: function postWebappSettings(webapp_settings) {
        console.log("Posting webapp settings");
        return axios.post("/api/process_webapp_settings",webapp_settings);
    }
}