APP_MANIFEST = {
    "parameters_selection": {},
    "display_left_panel": True,
    "app_title": "Recommendation explorer",
    "app_instructions": "This webapp aims to help you better evaluate your product recommendations model",
    "sections": [
        {
            "section_title": "User selection",
            "section_id": "user_selection",
            "section_is_collapsible": False,
            "section_has_helper": True,
            "section_helper": "Pick users to see their last interactions and their recommendations.",
            "section_parameters": [
                {
                    "parameter_title": "All users",
                    "parameter_id": "user_selection",
                    "parameter_type": "app_simple_or_multiple_selector",
                    "parameter_has_helper": False,
                    "parameter_helper": "Pick a user from the list of all users that get recommendations from the model.",
                    "specific_settings": {
                        "options": [],
                        "values": [],
                        "is_multiselect": False,
                    },
                }
            ],
        },
        {
            "section_title": "Advanced options",
            "section_id": "results_view",
            "section_is_collapsible": True,
            "section_has_helper": True,
            "section_helper": "",
            "section_parameters": [
                {
                    "parameter_title": "Display results style:",
                    "parameter_id": "results_display_style",
                    "parameter_type": "app_button_toggle",
                    "parameter_has_helper": True,
                    "parameter_helper": "How would you like to see the webapp results displayed?",
                    "specific_settings": {
                        "values": ["Pictures view", "Tabular view"],
                    },
                },
                {
                    "parameter_title": "Display already purchased items?",
                    "parameter_id": "display_already_purchased_items",
                    "parameter_type": "app_toggle",
                    "parameter_has_helper": True,
                    "parameter_helper": "It is possible the recommendation engine recommended items that were already purchased by customers. Would you like to display them in the list of recommendations?",
                    "specific_settings": {
                        "values": ["Pictures view", "Tabular view"],
                    },
                },
            ],
        },
    ],
    "layout_settings": {
        "layout_id": "vertical_split",
        "specific_settings": {
            "left_section_width_percent": 50,
            "left_section_title": "Purchases",
            "right_section_title": "Recommendations",
        },
    },
}