def flag_proba_for_webapp(recommendation_proba, model_threshold):
    worst_negative_activation_threshold = model_threshold - 0.05 * model_threshold
    low_negative_activation_threshold = model_threshold - 0.025 * model_threshold
    low_positive_activation_threshold = model_threshold + 0.0125 * model_threshold

    if recommendation_proba <= worst_negative_activation_threshold:
        webapp_quasar_color = "orange-10"
        proba_label = "Very Low"
    elif recommendation_proba <= low_negative_activation_threshold:
        webapp_quasar_color = "orange-8"
        proba_label = "Low"
    elif recommendation_proba < model_threshold:
        webapp_quasar_color = "blue-8"
        proba_label = "Almost good"
    elif (recommendation_proba >= model_threshold) and (
        recommendation_proba <= low_positive_activation_threshold
    ):
        webapp_quasar_color = "green-8"
        proba_label = "Good"
    elif recommendation_proba > low_positive_activation_threshold:
        webapp_quasar_color = "green-10"
        proba_label = "High"
    return webapp_quasar_color, proba_label


def prettify_proba(proba, n_digits=None):
  if n_digits is None:
    prettified_proba = round(proba, 2)
  else:
    prettified_proba = round(proba, n_digits)
  return prettified_proba


def generate_quasar_table_column_settings(column_name, column_label=None):
    if (column_label == "") or (column_label is None):
        column_label = column_name
    quasar_table_column_settings = {
        "name": column_name,
        "required": True,
        "label": column_label,
        "field": column_label,
        "align": "left",
        "sortable": True,
    }
    return quasar_table_column_settings


def set_app_manifest_select_values(app_manifest, select_values):
    print("Setting 'APP_MANIFEST' values...")
    app_manifest["sections"][0]["section_parameters"][0]["specific_settings"]["options"] = select_values
    app_manifest["sections"][0]["section_parameters"][0]["specific_settings"]["values"] = select_values
    print("'APP_MANIFEST' valuessuccessfully set !")
    return app_manifest