def handle_webapp_gauge_color(recommendation_proba, model_threshold):
    worst_negative_activation_threshold = model_threshold - 0.05 * model_threshold
    low_negative_activation_threshold = model_threshold - 0.025 * model_threshold
    almost_activation_values_threshold = model_threshold - 0.0125 * model_threshold
    low_positive_activation_threshold = model_threshold + 0.0125 * model_threshold
    #best_positive_activation_threshold = model_threshold + 0.025 * model_threshold

    if recommendation_proba <= worst_negative_activation_threshold:
        webapp_gauge_color = "orange-10"
    elif recommendation_proba <= low_negative_activation_threshold:
        webapp_gauge_color = "orange-8"
    elif recommendation_proba < model_threshold:
        webapp_gauge_color = "blue-8"
    elif (recommendation_proba >= model_threshold) and\
    (recommendation_proba <= low_positive_activation_threshold):
        webapp_gauge_color = "green-8"
    elif recommendation_proba > low_positive_activation_threshold:
        webapp_gauge_color = "green-10"
    return webapp_gauge_color


def load_user_item_data(user_id, list_of_item_ids, leverage_item_metadata, item_metadata_columns,
                        item_metadata_mapping, user_recommendations_data,
                        past_interaction_or_recommendation_items):
    user_item_data = []
    for item_id in list_of_item_ids:
        item_data = {
            "picture_id": item_id,
            "metadata": {}
        }
        if leverage_item_metadata:
            item_data["metadata"]["variables"] = item_metadata_columns
            item_data["metadata"]["content"] = item_metadata_mapping[item_id]  
        
        else:
            item_data["metadata"]["variables"] = []
            item_data["metadata"]["content"] = {}                                               
        
        if past_interaction_or_recommendation_items == "past_interaction_items":
            item_data["item_has_proba"] = False
        
        elif past_interaction_or_recommendation_items == "recommendation_items":
            item_data["item_has_proba"] = True
            item_data["recommendation_proba"] = user_recommendations_data[user_id]["recommendation_probas"][item_id]
            item_data["webapp_gauge_color"] = user_recommendations_data[user_id]["webapp_gauge_colors"][item_id]
        
        user_item_data.append(item_data)
    return user_item_data