# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
import re
import time

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
from project_root.dku_utils.core import get_current_project_and_variables
from project_root.dku_utils.folders.folder_commons import (get_managed_folder_metadata,
                                              get_managed_folder_id)
from project_root.dku_utils.folders.pictures.folder_pictures import (read_picture_bytes_from_managed_folder,
                                                                     write_bytes_picture_in_managed_folder)
from project_root.dku_utils.folders.pictures.pictures_utils import (convert_picture_from_bytes_to_pillow,
                                                                    homothetic_rescale_pillow_picture,
                                                                    convert_picture_from_pillow_to_bytes,
                                                                    convert_picture_from_base64_string_or_bytes_to_np_array,
                                                                    convert_picture_from_np_array_to_pillow)

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
from project_root.product_recommendations.config.webapp.constants import WEBAPP_DEFAULT_PICTURE_BASE64_STRING

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
project, variables = get_current_project_and_variables()
picture_max_shape = variables["standard"]["pictures_max_shape_app"]

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
item_pictures = dataiku.Folder(get_managed_folder_id(project, "item_pictures"))
all_picture_paths = item_pictures.list_paths_in_partition()
n_pictures = len(all_picture_paths)

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
#np_array_webapp_default_picture = \
#convert_picture_from_base64_string_or_bytes_to_np_array(WEBAPP_DEFAULT_PICTURE_BASE64_STRING)
#pillow_webapp_default_picture = convert_picture_from_np_array_to_pillow(np_array_webapp_default_picture)

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
#rgb_pillow_webapp_default_picture  = pillow_webapp_default_picture.convert('RGB')
#pillow_webapp_default_picture_rescaled = homothetic_rescale_pillow_picture(rgb_pillow_webapp_default_picture, picture_max_shape)
#bytes_webapp_default_picture = convert_picture_from_pillow_to_bytes(pillow_webapp_default_picture_rescaled, "jpeg")
#write_bytes_picture_in_managed_folder(project, "item_pictures_resized", bytes_webapp_default_picture, "webapp_default_picture.jpg")

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
item_pictures_resized = dataiku.Folder(get_managed_folder_id(project, "item_pictures_resized"))
already_resized_picture_paths = item_pictures_resized.list_paths_in_partition()

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
pictures_to_resize_paths = [picture_path
                            for picture_path in all_picture_paths
                            if picture_path not in already_resized_picture_paths]

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
start_time = time.time()
for picture_index, picture_path in enumerate(pictures_to_resize_paths):
    picture_name = re.sub("/", "", picture_path)
    print("Handling picture '{}' (n° {}/{} | Spent time: {} seconds) ..."\
          .format(picture_name, picture_index + 1, n_pictures, time.time() - start_time))
    bytes_picture = read_picture_bytes_from_managed_folder(project, "item_pictures", picture_path)
    pillow_picture = convert_picture_from_bytes_to_pillow(bytes_picture)
    pillow_picture_rescaled = homothetic_rescale_pillow_picture(pillow_picture, picture_max_shape)
    bytes_picture_rescaled = convert_picture_from_pillow_to_bytes(pillow_picture_rescaled, "jpeg")
    write_bytes_picture_in_managed_folder(project, "item_pictures_resized", bytes_picture_rescaled, picture_name)