# Recommendations Explorer

This [webapp](web_app:7N7vq0Y) will allow you to **audit and validate the behavior of your** ***Product Recommendations*** model.
It will allow you to select "users" from your operating system and put their historical purchases in perspective with the recommendations coming from the machine learning model.

# Interacting with the web application

To interact with this webapp, first, choose a user through the left panel: immediately after you selected it, results will appear on the right side of the webapp where you will see two sections:
- The **left section contains information about the items customers purchased** in your batch. 
- The **right section contains the top items recommendations** coming from the machine learning model. 

The animation below showcases this process :arrow_down:

![recommendations_explorer_user_selection.gif](TABVvHz0niO3)

# Pictures view: understanding the recommendation results

## Gauges color code
![recommendations_explorer_very_good.jpg](xZ1xKEyqv91c)

Gauges represent the probabilities the user has to interact with each item, based on the [recommendation_model](saved_model:TT58nj9o). 
They will be displayed with a color code from **<span style="color:#195F1F">dark-green</span>** (best recommendations) to **<span style="color:#E55100">dark-orange</span>** (worst ones) depending on their closeness to the threshold used by the [recommendation_model](saved_model:TT58nj9o). You can see a gauge example in the image above :arrow_up: .

Color code meaning:
- **<span style="color:#195F1F">This dark-green color</span>** means that probabity is **<span style="color:#195F1F">above the deployed model threshold</span>**.
- **<span style="color:#378E3C">This light-green color</span>** means that probabity is **<span style="color:#378E3C">above the deployed model threshold but still close to it</span>**.
- **<span style="color:#1A76D2">This blue color</span>** means that probabity is **<span style="color:#1A76D2">close to the deployed model threshold but under it</span>**.
- **<span style="color:#F57C01">This orange color</span>** means that probabity is **<span style="color:#F57C01">reasonably under the deployed model threshold</span>**.
- **<span style="color:#E55100">This dark-orange color</span>** means that probabity is **<span style="color:#E55100">too far under the deployed model threshold</span>**.


## Recommendations summary

![recommendations_explorer_legend_summary.png](rdsHtBMrayau)

The recommendations summary uses the same color code as above :arrow_up: to summarize the total number of items belonging to the following categories:
- **<span style="color:#195F1F">Very good</span>** means that probabilies are **<span style="color:#195F1F">above the deployed model threshold</span>**.
- **<span style="color:#378E3C">Good</span>** means that probabilies are **<span style="color:#378E3C">above the deployed model threshold but still close to it</span>**.
- **<span style="color:#1A76D2">Almost good</span>** means that probabilities are **<span style="color:#1A76D2">close to the deployed model threshold but under it</span>**.
- **<span style="color:#F57C01">Low</span>** means that probabilies are **<span style="color:#F57C01">reasonably under the deployed model threshold</span>**.
- **<span style="color:#E55100">Very low</span>** means that probabilies are **<span style="color:#E55100">too far under the deployed model threshold</span>**.

# Advanced options

## Display results style
![display_results_style.png](LwfcupBuyWWi)
You will have the possibility to **analyze this webapp results through two approaches**:
- **Pictures view** 
- **Tabular view**

We advise you to use the **Pictures view** if you have pictures from your products,  as it will facilitate the understanding of the results.

The animation below :arrow_down: shows the render for the two approaches, on the same product. 
![recommendations_explorer_pictures_and_tabular_view.gif](AZxuLPcvXwd3)
 
 ## Display already purchased items?
 ![display_already_purchased_items.png](X7Fkqy0L2O8o)
 The model will likely recommend "items" that have already been purchased by "users": these are by default hidden from the results.  **This section allows you to activate or deactivate the display of already purchased items in the results**.
 
 The animation below :arrow_down: shows an example of the usage of this parameter.
![display_already_purchased_items.gif](AeqSjMeNLhEe)
