# Slide presentation

This slide will let you assess your model's most important variables and understand the relationship between your input features and your model predictions.
Main sections:
- [Most important variables](#most-important-variables-1)
- [Partial dependencies](#partial-dependencies-1)

## Most important variables

![most_important_variables.png](ukHWNbuwbaZ2)

## Partial dependencies

A partial dependence plot shows the dependence of the predicted response on a single feature. The x-axis displays the value of the selected feature, while the y-axis displays the partial dependence.

The value of the partial dependence is by how much the prediction is higher or lower than the average.
⚠️ Partial dependencies charts associated with machine learning models trained automatically through the solution are by default computed on 10% of the test set, due to their computation time.

![partial_dependence_item_score.png](ucm5haIXuEis)

:arrow_forward: On the example above :arrow_up: you can see that the partial dependence of the *item_score_scaled* *(<-> affinity scores computed between the "users" and the "items")* has an almost linear shape: "user" interactions predicted probabilities tend to increase with the*item_score_scaled*.

![partial_dependence_item_user_age_45_99.png](b4IKx3PSUE4s)

:arrow_forward: On the example above :arrow_up: :
  - You can see the partial dependence of the *item_user_age_45_99_percent* *(Percent of people aged between 45 and 99 that interacted with the item)*: it seems that our model is more likely to predict a positive interaction when this variable increases. Partial dependence start to be positive around 0.25 *(<-> 25% of people aged between 45 and 99 )* but with a relatively small amplitude. 