# Slide presentation

This slide will help you better understand your "users" behavior so that you can better tune the parameters of the project [dataiku application](article:20). 
Main sections:
- [User analysis dynamic filtering](#user-analysis-dynamic-filtering-1)
- [Distinct user interactions distribution](#distinct-user-interactions-distribution-1)
- [Distribution of days separating each user interaction](#distribution-of-days-separating-each-user-interactions-1)
- [Daily and average user daily interactions](#daily-and-average-user-daily-interactions-1)


## User analysis dynamic filtering
The top left corner of the application can let you interact with the date range on which you want to assess all charts present in this slide, as sowcased on the animation below :arrow_down: :
![user_analysis_dynamic_filtering.gif](v2HmNqKQ1jol)

## Distinct user interactions distribution

Having a too-low or too-high number of interactions could naturally complexify the recommendations use case as:
- A too low number of interactions could lead to excessively sparse user-item interaction patterns, making it complex to find affinity scores. 
- A too high number of interactions could lead to excessively dense user-item interaction patterns, increasing the overall computation time. 

Thus, **this chart will allow you to observe the distribution of the number of user distinct interactions, based on all users involved in your data batch** :arrow_down:  .

![distribution_of_distinct_user_interactions.png](Ss7xMsvtqUJY)
 :arrow_up:  On the image above: 
- **<span style="color:#8F77A2">Blue bars indicate you the number of users that interacted on a range of interactions</span>** 
- **<span style="color:#FED48D">Each dot from the yellow curve shows the percentage of the total interactions that are covered under it</span>**.

###  Example
![distribution_of_distinct_user_interactions.gif](KGEYIpTCjkgM)
:arrow_up: The animation above shows you that   **<span style="color:#8F77A2">23.1k users had between 4 and 6 interactions</span>**, and **<span style="color:#FED48D">users that had between 0 and 6 interactions represent 83.6% of all users</span>**.


## Distribution of days separating each user interaction

As ***Product Recommendations*** machine learning model will have the role to predict the probability of "users" to interact with "items" based on their past behavior, we need, after we apply the [recommendation split](article:54), to have users that are both in the [collaborative_filtering_set](dataset:collaborative_filtering_set) and in the [machine_learning_set](dataset:machine_learning_set). To ensure having chances to get users in both datasets, it is better to have an idea of how much time tend to separate each user interaction. 

Thus, **this chart will allow you to observe the distribution of the number of days separating each user interaction, based on all users involved in your data batch** :arrow_down: .

![distribution_of_days_separating_each_user_interaction.png](Q0cL1sAcveoF)

:arrow_up:  On the image above: 
- **<span style="color:#8F77A2">Blue bars indicate you the number of time user successively interacted within a given range of days</span>** 
- **<span style="color:#FED48D">Each dot from the yellow curve shows the percentage of the total successive interactions that are covered under it</span>**.

###  Example
![distribution_of_days_separating_each_user_interaction.gif](dTrHmUs9zvAR)
:arrow_up: The animation above shows you that   **<span style="color:#8F77A2">14.82k user successive interactions were separated between 4 and 5 days</span>**, and **<span style="color:#FED48D">52.2% of all user successive interactions are done between 0 and 5 days</span>**.


## Daily and average user daily interactions

**This chart shows you, for each day ** **<span style="color:#8F77A2">the total number of interactions that occured</span>**, as well as **<span style="color:#80AAD8">the average number of daily interactions users had</span>**. It will help you to identify periods where users had a weaker or higher number of transactions.

![daily_and_average_daily_interactions.png](kJho9fVJnA0u)