# Slide presentation

This slide contains [sankey charts](https://www.dataiku.com/product/plugins/flow-charts/) that will give you an overview of the volume of "users" and "items" involved in your batch, among all collaborative key milestones.

**Sankey charts** are used to visualize paths through several states (in our case, those are the key steps of the ***Product Recommendations*** data processing). 
They are **composed of colored rectangles representing states and grey arrows representing flows between these states**.
:arrow_forward:  **The arrow widths are proportional to the flow’s volume**.

## Slide overview
The slide is composed of 4 Sankey charts representing the same collaborative filtering steps for "user" or "items". These charts are divided into two columns and two rows, as you can see on the screenshot below :arrow_down: : 
![recommendation_pipelines_overview.png](CY6tlJc2TzVb)
- Columns meaning:
    - First column contain the **users** recommendation pipeline informations.
    - Second column contain the **items** recommendation pipeline informations.
- Rows meaning:
    - The first row contains recommendation pipeline information about the volume in **absolute values**.
    - The second row contains recommendation pipeline information about the volume in **percentage**.

## Reading one chart
### States meaning
![recommendation_pipeline_example.png](Ub5vwN29V3rv)
All charts contain the same states:
- **<span style="color:#6A9DF6">all</span>** and **<span style="color:#DB4537">all'</span>**: corresponds to all users/items candidate for the collaborative filtering process. These are the users/items present in the dataset [user_item_interactions](dataset:user_item_interactions).

- \[Train interactions\] Collaborative filtering:
    - **<span style="color:#BD6ECA">in_cf</span>**: Corresponds to all users/items that are part of the dataset [collaborative_filtering_set](dataset:collaborative_filtering_set). 
    - [As a reminder](article:54), this is the dataset that contains all **user-item interaction records for computing the affinity scores** used to train a machine learning model.

    - **<span style="color:#FF8E6B">in_ml</span>**: Corresponds to all users/items that are part of the dataset [machine_learning_set](dataset:machine_learning_set).  
   - [As a reminder](article:54), this is the dataset that contains all **user-item interaction records for training a machine learning model**, based on the affinity scores computed based on **<span style="color:#FF8E6B">in_cf</span>** user-item interactions.

    - **<span style="color:#07ACC1">in_cf_&_ml</span>**: Corresponds to all users/items that are in both datasets [collaborative_filtering_set](dataset:collaborative_filtering_set) and [machine_learning_set](dataset:machine_learning_set). 

- \[All interactions\] Collaborative filtering:
    - **<span style="color:#F6C351">with_recos</span>**: Corresponds to all users/items that finally get recommendations in the dataset [user_top_interaction_predictions](dataset:user_top_interaction_predictions).
        - All users present in the dataset [user_item_interactions](dataset:user_item_interactions) are used for computing new collaborative filtering scores at the top of which we use the [recommendation_model](saved_model:TT58nj9o) to make predictions.

    - **<span style="color:#53B27A">with_strong_recos</span>**:  Corresponds to all user/items that finally get recommendations in the dataset [user_top_interaction_predictions](dataset:user_top_interaction_predictions), with **strong recommendations**: **strong recommendations being recommendations on which the [recommendation_model](saved_model:TT58nj9o) predicted that a user would interact with an item**.
        - **Recall**: the ***Product Recommendations*** *will propose TopN item recommendations to users but not all of these recommendations are mandatorily positively predicted ([See also the 'product_recommendations' article](article:61)). *

### Reading transitions

You will find below explanations on how to read the two kinds of Sankey charts, for the same project users.

#### Sankey chart in absolute values
![sankey_chart_absolute_values.gif](3lCI9ZtCKBPi)

- 240 597 initial users are in **<span style="color:#6A9DF6">all</span>** and **<span style="color:#DB4537">all'</span>**.
- \[Train interactions\] Collaborative filtering:
    - 235 472 users from  **<span style="color:#DB4537">all'</span>** are in **<span style="color:#BD6ECA">in_cf</span>**. 
    - 10 119 users from  **<span style="color:#DB4537">all'</span>** are in **<span style="color:#FF8E6B">in_ml</span>**. 
    - 4 994 users are common to **<span style="color:#BD6ECA">in_cf</span>**  and **<span style="color:#FF8E6B">in_ml</span>**  and present in **<span style="color:#07ACC1">in_cf_&_ml</span>**.
- \[All interactions\] Collaborative filtering:
    - 235 871 users from  **<span style="color:#DB4537">all'</span>**  get item recommendations in **<span style="color:#F6C351">with_recos</span>**.
    - 9 670 users from  **<span style="color:#F6C351">with_recos</span>** get strong recommendations are in **<span style="color:#53B27A">with_strong_recos</span>**.

#### Sankey chart in percentages
![sankey_chart_percentage_values.gif](cd9qCsCHA09D)
- 100 % of the initial users are in **<span style="color:#6A9DF6">all</span>** and **<span style="color:#DB4537">all'</span>**.
- \[Train interactions\] Collaborative filtering:
    - Users from **<span style="color:#DB4537">all'</span>** present  in **<span style="color:#BD6ECA">in_cf</span>** represent 97.86% of all the initial users. 
    - Users from **<span style="color:#DB4537">all'</span>** present  in  **<span style="color:#FF8E6B">in_ml</span>** represent 4.20% of all the initial users. . 
    - Users common to **<span style="color:#BD6ECA">in_cf</span>**  and **<span style="color:#FF8E6B">in_ml</span>**  and present in **<span style="color:#07ACC1">in_cf_&_ml</span>** represent 2.07% of all the initial users.
- \[All interactions\] Collaborative filtering:
    - Users from **<span style="color:#DB4537">all'</span>** present  in **<span style="color:#F6C351">with_recos</span>** represent 98.03% of all the initial users.
    - Users from **<span style="color:#F6C351">with_recos</span>** that get strong recommendations and are in **<span style="color:#53B27A">with_strong_recos</span>** represent 4.01% of all the initial users.