# Discipline definition
[Wikipedia's definition: ](https://en.wikipedia.org/wiki/Association_rule_learning) 
> **A recommendation engine** is a system that provides suggestions for items that are most pertinent to a particular user. 
Typically, the suggestions refer to various decision-making processes, such as what product to purchase, what music to listen to, or what online news to read.
Recommender systems are particularly useful when an individual needs to choose an item from a potentially overwhelming number of items that a service may offer.


# Industry solution scope 

![project_recommender_system_scope.png](zmPI4S5ROH5d)

The ***Product Recommendations*** industry solution is designed to:
- Handle implicit "user" feedbacks/interactions with "items" ...
    - *[How do we define "users" and "items"?](article:65)*
    - *[What are interactions and explicit/implicit feedbacks?](article:66)*.
- ... With item-based collaborative filtering ... 
    - *([What is collaborative filtering?](article:31))*
    - *[Where is "collaborative filtering" positioned in the recommender engines ecosystem?](article:67)*
- ... And model-based collaborative filtering, leveraging an [ensemble machine learning model](https://en.wikipedia.org/wiki/Ensemble_learning) at the top of the collaborative filtering scores.
    - *[What is model-based collaborative filtering?](article:69)*
    

