# Section presentation

The *Columns identification* section lets you identify the main columns playing a role in the ***Product Recommendations***  so that we can process their information in the flow.

![columns_identification.png](c5AViFSONLmg)


## interactions history
![interactions_history_columns.png](PGuEUr0iulhk)

#### Mandatory columns handling
- **Interaction date**: Specify here the column associated with the date at which users interacted with items in your interactions history.
- **Users identifier**: Specify here the column identifying each user in both:
    - Your interactions history. 
    - The user metadata dataset if you decided to activate *'Leverage user metadata?'* during the previous [Data specifications step](article:41).
- **Items identifier**: Specify here the column identifying each item in both:
    - Your interactions history. 
    - The item metadata dataset if you decided to activate *'Leverage item metadata?'* during the previous [Data specifications step](article:41).

#### Optional columns handling
- **Items revenue available?**: Precise if the items' revenue is available. If you activate it, you will be asked to specify the *Items revenue identifier*.
    - **Items revenue identifier**: Specify the column identifying the revenue/margin/price associated with each item interaction. Having this information will allow you to trigger another item selection strategy, based on the revenue, in the next*([Recommendation framing step](article:43))*.
    
## user metadata
You can only see this tile parameter if you decided to activate *'Leverage user metadata?'* during the previous [Data specifications step](article:41)
![user_metadata_columns.png](YkH0bHYARGpP)
- **Available user metadata**: Precise which type of data you want to use in the application. You will have to choose between:
    - **User age**: Enabling this option will allow applying specific age feature engineering in the flow:
        - Computing the 'User age cluster' each user has, thanks to the [ages_clustering_model](saved_model:uAq5AxzM).
        - For each item:
            - The percentage of people belonging to each 'User age cluster' that interacted with each item.
            - The average age users that interacted with the item had.
            - The standard deviation of the age of users that interacted with the item.
       - For each user-item interaction: the delta between its age and the average age users that interacted with the item had.
    - **Other user metadata** Enabling this option will allow enriching the machine learning model with all user metadata as features: 
    - **User age and other user metadata**: Enabling this option will allow using the features from the two options presented before.

:arrow_forward:  In case you selected *'User age'* or *'User age and other user metadata'*, you will then be asked to specify:
- **Users age column**: The column identifying each user's age in the user metadata dataset.

## item metadata
You can only see this tile parameter if you decided to activate the parameters:
- *'Use product pictures?'* during the previous [Connection settings step](article:40).
- *'Leverage item metadata?'* during the previous [Data specifications step](article:41).
![item_metadata_columns.png](Db3m00pjuEj0)
- **Item picture column**: Specify the name of the column giving each 'item picture name' in the item metadata dataset.

## columns refresh button
![columns_refresh_button.png](6uCk46n7ElCs)
⚠️ Don't forget to click on the **<span style="color:#FFFFFF;background-color:#30ADDD">  REFRESH</span>** button to let the application update the following steps based on your selection.
