# Section presentation

The *Recommendation framing* section allows framing the main parameters associated with the ***Product Recommendations***  data batch.

![recommendation_framing.png](v5kEdOO6JRCC)


## Batch parameters
![batch_parameters.png](oP3jmAR7tOZD)
- **Data available until now?**: This boolean parameter helps to precise if your data is up to date or not. 
    - If this is not the case, you will be asked to fill in the parameter **Batch last interaction date** that indicates the last date to use in the dataset [interactions_history](dataset:interactions_history).

- **Backward window in weeks**: Indicate here the number of past weeks of data to ingest in the application.

- **Number of weeks for the machine learning set**: Indicate here the number of most recent weeks of data that should be taken to train a machine learning model.
    - ⚠️ You must have *'Number of weeks for the machine learning set'* < *'Backward window in weeks'*.


## Users selection
![users_selection.png](zUHaKcBKqaKG)

- **Minimum number of interactions per user**: Indicate the minimum number of interactions that must be recorded so that a user can be a candidate for the collaborative filtering process.
    - Filtering users allows to reduce the recommendation problem cardinality *([Get more explanations on this](article:34))*

## Items selection
![items_selection.png](1XU72Ooi6aRQ)

- **Items selection strategy**: Indicate the strategy to apply to filter items: 
    - **Keep items based on their interactions contribution**: This option will result in keeping the items that had the most interactions in the data batch.
    - **Keep items based on their revenue contribution**: This option will result in keeping the items that had contributed the most to revenue in the data batch.
        - You can only see this option if you activated  'Items revenue available?' during the previous [Columns identification step](article:42).
    - Filtering items allows to reduce the recommendation problem cardinality *([Get more explanations on this](article:34))*

- **Distribution contribution % threshold**: This threshold **X**, in percent, will have the effect to keep items that contributed to X% of the total interactions/revenue for the collaborative filtering pipeline. 
    - If your *'Items selection strategy'* is *'Keep items based on their interactions contribution'*: All the items that generated **X %** of all interactions will be kept.
    - If your *'Items selection strategy'* is *'Keep items based on their revenue contribution'*: All the items that generated **X %** of all revenue will be kept.

## User recommendations
![user_recommendations.png](JaUQ8y2vxkyh)

- **Maximum number of recommendations**: Indicate here the maximum number of items **N** to recommend to users. The **N** items that get the best recommendation will then be kept for each user. 