# Section presentation

The *Recommendation feature engineering* section allows you to configure how you want to apply feature engineering in the ***Product Recommendations***.

![recommendation_feature_engineering.png](Z7bILDco0DLC)

## item metadata

![item_metadata_feature_engineering.png](Mgbo4PZ47a2o)
- **Leverage item metadata for**: Indicate here how you want to use the item metadata for feature engineering. You will have the choice between three options: 
    - **Item characteristics feature engineering**: Collaborative filtering will be applied on the 'user-item-characteristics' interactions recoreded in your batch. Dedicated flow zones will be created to allow this computation *([Learn more on the item characteristics collaborative filtering](article:56))*
    - **Model features enrichment**: Item characteristics will be joined to all other features so that the [recommendation_model](saved_model:TT58nj9o) can take them into account.  
    - **Item characteristics feature engineering and model features enrichment**: The two feature engineering approaches mentioned above will be used.

- **Item characteristics columns**: You can only see this option if 'Item characteristics feature engineering' is part of the previous parameter. Select here the item characteristics columns to use for computing collaborative filtering features.

## user metadata
![user_metadata_feature_engineering.png](v9zTZUGC7K9y)

- **Retrain user ages clustering model?**: Precise if you want to retrain the [ages_clustering_model](saved_model:uAq5AxzM) during the flow build. 
    - You can only interact with this option if: 
        - You activated 'Leverage user metadata?' during the [Data specifications](article:41).
        - You have precise that 'User age' is part of the 'Available user metadata' during the [Columns identification](article:42).
        - The [ages_clustering_model](saved_model:uAq5AxzM) has been trained at least one time.
