![flow_zones_macro_view_collaborative_filtering_items.png](wZwKFYMGLe5O)

# Flow zone presentation


The [collaborative_filtering|items](flow_zone:f1xfO1Z) is in charge of computing *Item-based* affinity scores between users and items.
- [Learn more about collaborative filtering](article:31).

![flow_zone_collaborative_filtering_items.png](qzEQSUqiMmaA)


# Main steps
- Recipe [compute_item_affinities_for_learning](recipe:compute_item_affinities_for_learning) computes affinity scores based on **user-item interactions recorded in weeks having a week scope equals to "collaborative_filtering"**  (*[See also the time split design flow zone](article:52)*). 
    
    :arrow_forward: Resulting information is stored in dataset [item_affinities_for_learning](dataset:item_affinities_for_learning).
 
- Recipe [compute_item_affinities](recipe:compute_item_affinities): 
    - Computes affinity scores for **ALL user-item interactions recorded in the batch**. 
        
        :arrow_forward: Resulting information is stored in dataset [item_affinities](dataset:item_affinities).
    
    - Computes similarities observed between items. 
        
        :arrow_forward: Resulting information is stored in dataset [item_similarities](dataset:item_similarities).

- Recipe [compute_all_item_affinities](recipe:compute_all_item_affinities) stacks/unions the previously computed "item_affinities" datasets so that common data processing steps can be applied on their content. 
    
    :arrow_forward: Resulting information is stored in dataset [all_item_affinities](dataset:all_item_affinities). 

- Recipe [compute_item_scores](recipe:compute_item_scores) aggregates the minimum and maximum affinity scores each item gets so that we can later apply [Min-Max scaling](https://en.wikipedia.org/wiki/Feature_scaling#Methods) on each user-item interaction.
    
    :arrow_forward: Resulting information is stored in dataset [item_scores](dataset:item_scores). 

- Recipe [compute_all_item_affinities_enriched](recipe:compute_all_item_affinities_enriched) joins the "Min" and "Max" scores previously computed in the dataset [item_scores](dataset:item_scores) to the dataset [all_item_affinities](dataset:all_item_affinities) to apply the [Min-Max scaling] formula on each user-item interaction.
    
    :arrow_forward: Resulting information is stored in dataset [all_item_affinities_enriched](dataset:all_item_affinities_enriched).

- <span style="color:#e0c587">Optionally, recipe [compute_user_item_metadata_and_affinities](recipe:compute_user_item_metadata_and_affinities),  joins dataset [user_metadata_prepared](dataset:user_metadata_prepared) to the dataset [all_item_affinities_enriched](dataset:all_item_affinities_enriched) so that all affinity scores coming from the item characteristics collaborative filtering flow zones (*[See \[Optional\] Item characteristics collaborative filtering](article:56)*) can enrich</span> **the core user-item affinity scores data**.
    
    :arrow_forward: Resulting information is stored in dataset [user_item_metadata_and_affinities](dataset:user_item_metadata_and_affinities).

