![flow_zones_macro_view_collaborative_filtering_item_characteristics.png](0oI8HZOKcEpJ)

# Flow zones presentation


The *<span style="color:#e0c587">optional item characteristics collaborative filtering flow zones</span>* are in charge of computing *Item-based* affinity scores between users and **item characteristics**.
- [Learn more about collaborative filtering](article:31).


The intuition behind this process is to not only compute features around the interest a user has in a precise item but also enrich it with features around the interest the user has in the item properties. 
**With a concrete example:**  * **Product Recommendations** can compute affinity scores between a customer and t-shirts. It can also compute affinity scores between the same customer and t-shirt characteristics such as 't-shirt types', 't-shirt colors', etc...*


*<span style="color:#e0c587">Item characteristics collaborative filtering flow zones being optional,</span>*  they will appear in the flow only if you asked to leverage item metadata for item characteristics feature engineering. They are computationally generated in the flow if that is the case. Else, they are removed.

All  these flow zones will have the same structure, as you can see in the two examples in the next section:

# Examples
Below is an example of a flow zone built after we set to use the *universe* column for user-universe collaborative filtering: It leads to the creation of the flow-zone *collaborative_filtering|item_universe* :arrow_down:  
![flow_zone_collaborative_filtering_item_characteristics_universe.png](aGK7baW4B7PZ)


Below is another example of a flow zone built after we set to use the *main_color* column for user-universe collaborative filtering: It leads to the creation of the flow-zone *collaborative_filtering|item_main_color* :arrow_down:  
![flow_zone_collaborative_filtering_item_characteristics_main_color.png](mvb5w2hhgC7I)

# Main steps

## Main steps/1: Creating the item characteristic flow zone

First of all, the flow zone associated with the item characteristic will be created if it does not exist. 
The flow zone name will be "collaborative_filtering|item__**<span style="color:#e0c587">NAME_OF_THE_CHARACTERISTIC_COLUMN</span>**".
**Example** : If you want to apply *Item characteristics collaborative filtering* based on a item metadata column named "**<span style="color:#e0c587">main_category</span>**", the flow zone created will be named "collaborative_filtering|item__**<span style="color:#e0c587">main_category</span>**".

In the following step, we will consider using this same "**<span style="color:#e0c587">main_category</span>**" column in the *Item characteristics collaborative filtering* process.

## Main steps/2: Item characteristic flow zone steps


- Recipe **_compute__item<span style="color:#e0c587">_main_category</span>_affinities_for_learning** computes affinity scores based on **user-main_category interactions recorded in weeks having a week scope equals to "collaborative_filtering"**  (*[See also the time split design flow zone](article:52)*). 
    
    :arrow_forward: Resulting information is stored in a dataset named **_item<span style="color:#e0c587">_main_category</span>_affinities_for_learning**.
 
- Recipe **_compute__item<span style="color:#e0c587">_main_category</span>_affinities** computes  affinity scores based on **ALL user-item interactions recorded in the batch**. 
    
    :arrow_forward: Resulting information is stored in a dataset named **_item<span style="color:#e0c587">_main_category</span>_affinities**.

- Recipe **_compute__all_item<span style="color:#e0c587">_main_category</span>_affinities**  stacks/unions the previously computed "item_affinities" datasets so that common data processing steps can be applied to their content. 
    
    :arrow_forward: Resulting information is stored in a dataset named **_all_item<span style="color:#e0c587">_main_category</span>_affinities**.

- Recipe **_compute__item<span style="color:#e0c587">_main_category</span>_min_max_scores**  aggregates the minimum and maximum affinity scores each item gets so that we can later apply [Min-Max scaling](https://en.wikipedia.org/wiki/Feature_scaling#Methods) on each user-item interaction.
    
    :arrow_forward: Resulting information is stored in a dataset named **_item<span style="color:#e0c587">_main_category</span>_min_max_scores**.

- Recipe **_compute_all_item<span style="color:#e0c587">_main_category</span>_affinities_enriched**  joins the "Min" and "Max" scores previously computed in dataset **_item<span style="color:#e0c587">_main_category</span>_min_max_scores** to the dataset **_all_item<span style="color:#e0c587">_main_category</span>_affinities** to apply the [Min-Max scaling] formula on each user-item interaction.
    
    :arrow_forward: Resulting information is stored in a dataset named **_all_item<span style="color:#e0c587">_main_category</span>_affinities_enriched**.