![flow_zones_macro_view_age_feature_engineering.png](1hNNMxbrLVnb)

# Flow zone presentation


The **<span style="color:#e0c587">optional </span>** [age_feature_engineering](flow_zone:HDgQgQy) computes features leveraging the **user_age** KMeans clusters computed during [the ages_clustering step](article:53).

![flow_zone_age_feature_engineering.png](ukyPeLrNWv3F)


# Main steps

- Recipe [compute_age_features_by_item_for_learning](recipe:compute_age_features_by_item_for_learning) pivots the **user_age_cluster** column for all **user-item interactions recorded in weeks having a week scope equals to "collaborative_filtering"**  (*[See also the time split design flow zone](article:52)*). 
 It computes :
    - The count of people belonging to each **user_age cluster** that interacted with each item.
    - The average **user_age**.
    - The standard deviation of **user_age**.
    
    :arrow_forward: Resulting information is stored in dataset [age_features_by_item_for_learning](dataset:age_features_by_item_for_learning).
 
- Recipe [compute_all_age_features_by_item](recipe:compute_all_age_features_by_item) computes affinity scores for **ALL user-item interactions recorded in the batch**.  It computes :
    - The count of people belonging to each cluster that interacted with each item.
    - The average **user_age**.
    - The standard deviation of **user_age**.
    
    :arrow_forward: Resulting information is stored in dataset [age_features_by_item](dataset:age_features_by_item).


- Recipe [compute_all_age_features_by_item](recipe:compute_all_age_features_by_item) stacks/unions the previously computed "age_features_by_item" datasets so that common data processing steps can be applied to their content. 
    :arrow_forward: Resulting information is stored in dataset [all_age_features_by_item](dataset:all_age_features_by_item). 
 
- Finally, recipe [compute_all_age_features_by_item_prepared](recipe:compute_all_age_features_by_item_prepared) computes the percentages each **user_age cluster** represents compared to the total number of interactions.
 
 :arrow_forward: Resulting information is stored in dataset [all_age_features_by_item_prepared](dataset:all_age_features_by_item_prepared).