![flow_zones_macro_view_negative_sampling.png](tp016KXyFL0Y)

# Flow zone presentation


The [negative_sampling](flow_zone:DuZI5o8) is mainly responsible for applying negative sampling on the [machine_learning_set](dataset:machine_learning_set) dataset computed during the [recommendation split](article:54) step.

![flow_zone_negative_sampling.png](2vawMwicR7uy)

# Main steps

- Recipe [compute_final_machine_learning_set](recipe:compute_final_machine_learning_set) applies negative sampling on the dataset [machine_learning_set](dataset:machine_learning_set), leveraging datasets. 
    - [final_collaborative_filtering_set](dataset:final_collaborative_filtering_set): as the dataset of user-item samples with affinity scores and other numerical features.
    - [user_item_interactions](dataset:user_item_interactions): as the dataset of historical user-item samples used to compute the affinity scores.

 :arrow_forward: Resulting information is stored in dataset [final_machine_learning_set](dataset:final_machine_learning_set)
 
-  **<span style="color:#e0c587">Optionally</span>**, recipe [compute_final_machine_learning_set_enriched](recipe:compute_final_machine_learning_set_enriched) enriches the dataset containing both positive and negative sampling interactions with datasets :
    - [item_metadata_prepared](dataset:item_metadata_prepared) if you set in the application to leverage **item metadata** for training your machine learning model.
    - [user_metadata_prepared](dataset:user_metadata_prepared) if you set in the application to leverage **user metadata** for training your machine learning model.
    - [batch_users_with_ages_clusters](dataset:batch_users_with_ages_clusters) if you set in the application to leverage **user_age**.
    
 :arrow_forward: Resulting information is stored in dataset [final_machine_learning_set_enriched](dataset:final_machine_learning_set_enriched)
    
- Finally, recipe [compute_final_machine_learning_set_prepared](recipe:compute_final_machine_learning_set_prepared) applies some last data preparation to generate the dataset [final_machine_learning_set_prepared](dataset:final_machine_learning_set_prepared) on which the ***Product Recommendations*** machine learning model is trained.
 
 :arrow_forward: This recipe has as an input: 
     - [final_machine_learning_set](dataset:final_machine_learning_set) if it is not set in the application to leverage **item metadata**, **user metadata** or **user_age**. 
     - [final_machine_learning_set_enriched](dataset:final_machine_learning_set_enriched) in the other case.
    