# Interactions
An interaction can refer to several underlying concepts. 
**Example**: *As a marketplace, the fact that one product (or "item") has been mouse-over, added to a cart, or purchased by a customer (or "user") refers to three different kinds of interactions*. 

Mixing different kinds of interactions as inputs of a recommender system should be avoided as much as possible. If it is required to do so, here are the risks:
- **The underlying user patterns can vary from one interaction type to another**. Back to the previous example, it is not because you mouse over a product that you will add it to the cart or even purchase it. Similarly, even if these are close steps, it is not because you added a product to your cart that you will purchase it mandatorily. **Mixing different interactions comes with solid assumptions on your "users" behavior**. 
- We do not know which kind of recommendations the system outputs. You can think of your recommender system as a box ingestion of user-item interactions and outputting item recommendations. But the item recommendations are linked to the history of the past interactions, and then **an item recommendation is in fact, a recommendation to the user of an interaction with an item**. Back again to the previous example, how will you know if your recommendation is a recommendation to "mouseover," "add to cart," or "purchase"? 

Defining precisely the concepts of "user," "items," and "user interactions" before starting any recommender engine modeling is then fundamental.

## Interaction types
As the interactions are a way to tell us how our "users" considered our "items," we name them "feedbacks." **User interactions or feedback can be of two types: Explicit and Implicit**: 
- **Explicit feedback** occurs when "users" explicitly bring information about how they perceived the "items." It can, for example, be done through item ratings, likes or dislikes, or any other user-satisfaction metric. 
    - **Example**: Somebody rated a movie 4,5/5.
- **Implicit feedback** occurs when "users" simply interacted with "items": We don't know how they perceived their interaction, but we know they chose to interact. 
    - **Example**: Somebody watches a movie. We don't know if she/he appreciated it, but we know she/he watched it. 
    

**NOTE**: **The** ***Product Recommendations***  **is designed to work with implicit feedbacks**.
