<span id="version" style="color: grey; float: right">Version 2.1.4</span>

# Project goal
This project helps you design a recommender system engine so that you can propose personalized products to your customers.


# Project value
Companies' customer base can grow, and their product catalog constantly evolves. Tastes of individual customers and customer communities vary over time and depend on the available products. All of this results in complex ephemeral purchasing patterns, making proposing to customers both customized and relevant recommendations a challenging task.
This context brings the need for flexibility in the recommender system designs: it is decisive to iterate quickly over several modeling approaches, evaluate them easily, and be able to audit their behavior.

:arrow_forward:  The ***Product Recommendations*** solution will let you handle all these components so that you can answer several needs, among which:


## I want to visualize and audit my recommendation model behavior
The [Recommendations explorer](article:22) will allow you to select "users" from your operating system and put their historical purchases in perspective with the recommendations coming from the machine learning model so that you can better understand how your model behaves and validate it from a business standpoint.
![recommendations_explorer_user_selection.gif](uj89DploP77l)


## I want to evaluate my recommendation model performances accurately
Leverage the [recommendation model evaluation part](article:24) to assess your recommendation model global performances.
![confusion_matrix.gif](He1Cvx4BN41H)

Thanks to the subpopulation analysis, as well as its performances depending on your product characteristics or user age clusters!
![subpopulation_analysis.gif](IiaPibNubZhM)

## I want to have insights into my customers' and products' past interactions

A [user analysis](article:26) will help you better understand your customers' behavior.
![user_analysis_dynamic_filtering.gif](4Mwuxt2qwOkN)

An [item analysis](article:27) will help you better understand how your products are solicited
![items_interactions_or_revenue_distribution.gif](8hAtTPR62uvs)

Leverage these insights to optimize your application parameters better.


## I want my recommendation model to leverage customer and product characteristics
The project comes with the ability to handle user and item metadata to extend its feature engineering capabilities.

![data_specifications.png](FOXOMNs0CHNu)


## I want to iterate over different recommendation modeling scenarios quickly
The project will let you create as many applications as you want so that you can experiment with multiple batch parameters in parallel.




