import dataiku


def update_one_schema_column(project_key, dataset_name, column_name, new_datatype):
    import dataiku
    L_new_schema = []
    client = dataiku.api_client()
    project = client.get_project(project_key)
    
    dataset = project.get_dataset(dataset_name)
    dataset_definition = dataset.get_definition()
    dataset_schema = dataset_definition['schema']['columns']
    
    for entity in dataset_schema:
        if entity['name']==column_name:
            entity['type']=new_datatype
        L_new_schema.append(entity)
    dataset_definition['schema']['columns'] = L_new_schema
    dataset.set_definition(dataset_definition)
    print("dataset successfully updated ! ")
    pass


def get_managed_folder_info(project_key, managed_folder_name):
    client = dataiku.api_client()
    project = client.get_project(project_key)
    managed_folders = project.list_managed_folders()
    for index, folder in enumerate(managed_folders):
        if folder['name'] == managed_folder_name:
            folder_index = index
    folder_info = managed_folders[folder_index]
    return folder_info


def get_managed_folder_id_with_folder_name(project_key, managed_folder_name):
    folder_info = get_managed_folder_info(project_key, managed_folder_name)
    return folder_info["id"]



def remove_pickle_extension(pickle_name):
    import re
    return re.sub("\.p$", "", pickle_name)


def write_pickle_in_dss_folder(data, pickle_name, folder_id):
    import io
    import pickle
    
    dss_folder = dataiku.Folder(folder_id)
    pickle_bytes = io.BytesIO()
    pickle.dump(data, pickle_bytes)
    pickle_name = remove_pickle_extension(pickle_name)
    with dss_folder.get_writer(f"{pickle_name}.p") as w:
        w.write(pickle_bytes.getvalue())
        pass
    pass


def read_pickle_from_dss_folder(pickle_name, folder_id):
    import pickle
    
    dss_folder = dataiku.Folder(folder_id)
    pickle_name = remove_pickle_extension(pickle_name)
    with dss_folder.get_download_stream(f"{pickle_name}.p") as f:
        data = f.read()
        pickle_data = pickle.loads(data)
    f.close()
    return pickle_data