def enrich_with_dictionary(main_dictionary, second_dictionary, update_main_dictionary):
    """
    Enriches a main dictionary with the key/values contained in a second dictionary.

        :param main_dictionary : dict | the main dictionary to feed.
        :param second_dictionary : dict | the feeding second dictionary.
        :param update_main_dictionary : bool | boolean parameter to set if the 'second_dictionary' keys
            can update existing keys in the 'main_dictionary'

        :return: main_dictionary : dict | 'main_dictionary' enriched with 'second_dictionary' keys.
        :rtype: dict
    """

    main_dictionary_keys = main_dictionary.keys()
    for key in second_dictionary.keys():
        if key not in main_dictionary_keys:
            main_dictionary[key] = second_dictionary[key]
        else:
            if update_main_dictionary:
                main_dictionary[key] = second_dictionary[key]

    return main_dictionary