import pyproj
from functools import partial
from shapely.ops import transform
from shapely.geometry import Point, Polygon

from ..formating.polygons import convert_polygon_from_shapely_to_list


def compute_circular_polygon(circle_center_lon, circle_center_lat, circle_radius_m):

    local_azimuthal_projection = "+proj=aeqd +R=6371000 +units=m +lat_0={} +lon_0={}".format(
        circle_center_lat, circle_center_lon
    )
    wgs84_to_aeqd = partial(
        pyproj.transform,
        pyproj.Proj("+proj=longlat +datum=WGS84 +no_defs"),
        pyproj.Proj(local_azimuthal_projection),
    )
    aeqd_to_wgs84 = partial(
        pyproj.transform,
        pyproj.Proj(local_azimuthal_projection),
        pyproj.Proj("+proj=longlat +datum=WGS84 +no_defs"),
    )

    center = Point(float(circle_center_lon), float(circle_center_lat))
    point_transformed = transform(wgs84_to_aeqd, center)
    buffer = point_transformed.buffer(circle_radius_m)

    shapely_circular_polygon = transform(aeqd_to_wgs84, buffer)
    circular_polygon = convert_polygon_from_shapely_to_list(shapely_circular_polygon, reverse_coordinates=False)
    return circular_polygon


def compute_polygon_envelope(polygon):
    polygon = Polygon(polygon)
    envelope = polygon.envelope
    longitudes, latitudes = envelope.exterior.coords.xy
    return longitudes, latitudes
