import numpy as np
import shapely
from shapely.ops import unary_union

from .information_extraction import get_shapely_polygon_length


def union_polygons(list_of_shapely_polygons, union_strategy):
    polygons_union = unary_union( list_of_shapely_polygons )
    union_strategies = ["keep_biggest_polygon", "keep_smallest_polygon", "keep_all_polygons"]
    polygons_union_is_a_multi_polygon = not isinstance( polygons_union, shapely.geometry.polygon.Polygon )

    if polygons_union_is_a_multi_polygon:
        polygon_type = "multi_polygon"
        polygons_lengths = [get_shapely_polygon_length( polygon ) for polygon in polygons_union]

        if union_strategy in union_strategies:
            if union_strategy == "keep_biggest_polygon":
                biggest_polygon_index = np.argmax( polygons_lengths )
                polygons_union = polygons_union[biggest_polygon_index]

            elif union_strategy == "keep_smallest_polygon":
                smallest_polygon_index = np.argmin( polygons_lengths )
                polygons_union = polygons_union[smallest_polygon_index]

            elif union_strategy == "keep_all_polygons":
                polygons_union = polygons_union
        else:
            raise Exception( f"union_strategy '{union_strategy}' Not yet implemented !" )
            pass
        pass

    else:
        polygon_type = "single_polygon"
        pass

    return polygons_union, polygon_type


def union_all_shapely_polygons(shapely_multipolygon):
    shapely_polygon = unary_union(shapely_multipolygon)
    return shapely_polygon
