from ..flow.constants import (N_NEIGHBORS_POLYGONS_TO_SEARCH,
                              N_SUCCESSIVE_EXCLUSIONS_STOPPING,
                              SEARCH_INCLUSION_IN_MULTIPLE_POLYGONS)


def lookup_census_features(reference_geo_point, census_metadata, census_polygons_indexer):
    reference_geo_point_belonging_polygons, n_polygons_found =\
    census_polygons_indexer.search_single_geo_point_belonging_polygons(reference_geo_point,
                                                                       N_NEIGHBORS_POLYGONS_TO_SEARCH,
                                                                       N_SUCCESSIVE_EXCLUSIONS_STOPPING,
                                                                       SEARCH_INCLUSION_IN_MULTIPLE_POLYGONS)
    if len(reference_geo_point_belonging_polygons) > 0:
        reference_geo_point_belonging_polygon = reference_geo_point_belonging_polygons[0]
        census_features = census_metadata[reference_geo_point_belonging_polygon]
    else:
        census_features = {}
    return census_features

