import requests
import time

from ..geographic_handling.feature_engineering.information_extraction import get_geodesic_distance
from ..geographic_handling.formating.points import convert_from_list_geo_point_to_geojson


def load_features_from_parameters(parameters):
    living_surface = int(parameters["living_surface"])
    
    # Number of rooms :
    number_of_rooms = int(parameters["number_of_rooms"])
    if number_of_rooms > 8:
        number_of_rooms = 9
    # Lots : 
    has_lots = parameters["has_lots"]
    if has_lots:
        number_of_lots = int(parameters["number_of_lots"])
        if number_of_lots > 4:
            number_of_rooms = 5
    else:
        number_of_lots = 0
    
    features = {
        "living_surface": living_surface,
        "number_of_rooms": number_of_rooms,
        "number_of_lots": number_of_lots
    }
    
    print("Features loaded from parameters : {}".format(living_surface))
    
    return features

def geocode_address(address, sleep_time):
    import time
    import requests

    time.sleep(sleep_time)
    url = "https://photon.komoot.io/api/"
    params = {
        "q": address,
        "limit": 1
    }

    try:
        response = requests.get(url, params=params, timeout=5)
        response.raise_for_status()
        data = response.json()
        print("Geocoding response : '{}'".format(data))

        features = data.get("features", [])
        if features:
            coords = features[0]["geometry"]["coordinates"]
            address_latitude = coords[1]
            address_longitude = coords[0]
            address_geojson = convert_from_list_geo_point_to_geojson([address_longitude, address_latitude])
            return {
                "address_successfully_geocoded": True,
                "address_latitude": address_latitude,
                "address_longitude": address_longitude,
                "address_geojson": address_geojson
            }
        else:
            return {"address_successfully_geocoded": False}

    except Exception as e:
        print(f"Error during geocoding: {e}")
        return {"address_successfully_geocoded": False}

    
def enrich_address_with_city_name(address):
    lower_case_address = address.lower()
    if not "paris" in lower_case_address:
        address = "{} PARIS".format(address)
    return address