# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# Read recipe inputs
test_set_prediction_metrics = dataiku.Dataset("test_set_prediction_metrics")
test_set_prediction_metrics_df = test_set_prediction_metrics.get_dataframe()
metrics_cols = list(test_set_prediction_metrics_df.columns)

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
ascending_time_df = test_set_prediction_metrics_df.sort_values(by="date", ascending=True).head(1)
ascending_time_df

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
descending_time_df = test_set_prediction_metrics_df.sort_values(by="date", ascending=False).head(1)
descending_time_df

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
final_schema = []
for column in metrics_cols:
    ascending_time_df_column_name = "first_deployment_{}".format(column)
    descending_time_df_column_name = "last_deployment_{}".format(column)
    ascending_time_df.rename({column:ascending_time_df_column_name}, axis=1, inplace=True)
    ascending_time_df.index = [0]
    descending_time_df.rename({column:descending_time_df_column_name}, axis=1, inplace=True)
    descending_time_df.index = [0]
    ascending_time_df[descending_time_df_column_name] = descending_time_df[descending_time_df_column_name]
    final_schema += [ascending_time_df_column_name, descending_time_df_column_name]

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
ascending_time_df = ascending_time_df[final_schema]

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# Write recipe outputs
first_and_last_metrics = dataiku.Dataset("first_and_last_metrics")
first_and_last_metrics.write_with_schema(ascending_time_df)