// MAP : 
// Creating map options
let mapOptions = {
    center: [48.856614, 2.3522219],
    zoom: 12
} 

// Creating a map object
let map = new L.map('map_container', mapOptions);
let layer = new L.TileLayer('https://{s}.basemaps.cartocdn.com/rastertiles/light_all/{z}/{x}/{y}.png')
// Adding layer to the map
map.addLayer(layer);
let map_layers = new L.LayerGroup();
map_layers.addTo(map);

// Address :
let address_input = document.getElementById("address_input");
// Geocoding issue message :
let geocoding_issue = document.getElementById("geocoding_issue");

// Property type :
//let property_type_selector = document.getElementById("property_type_selector");
// Living surface : 
let metric_living_surface_label = document.getElementById("metric_living_surface_label");
let metric_living_surface_slider = document.getElementById("metric_living_surface_slider");
let metric_living_surface_displayed_value = document.getElementById("metric_living_surface_displayed_value");
metric_living_surface_displayed_value.innerHTML = metric_living_surface_slider.value;
metric_living_surface_slider.oninput = function() {
  metric_living_surface_displayed_value.innerHTML = metric_living_surface_slider.value;
}

// Number of rooms : 
let metric_rooms_label = document.getElementById("metric_rooms_label");
let metric_rooms_slider = document.getElementById("metric_rooms_slider");
let metric_rooms_displayed_value = document.getElementById("metric_rooms_displayed_value");
metric_rooms_displayed_value.innerHTML = metric_rooms_slider.value;
metric_rooms_slider.oninput = function() {
  metric_rooms_displayed_value.innerHTML = metric_rooms_slider.value;
}

// Lots :
let lots_params_container = document.getElementById("lots_params_container");
let lots_switch_container = document.getElementById("lots_switch_container");

//// Number of lots : 
let metric_n_lots_label = document.getElementById("metric_n_lots_label");
let metric_n_lots_slider = document.getElementById("metric_n_lots_slider");
let metric_n_lots_displayed_value = document.getElementById("metric_n_lots_displayed_value");
metric_n_lots_displayed_value.innerHTML = metric_n_lots_slider.value;
metric_n_lots_slider.oninput = function() {
  metric_n_lots_displayed_value.innerHTML = metric_n_lots_slider.value;
}

lots_switch_container.onchange = function(){
    property_has_lots = CheckboxIsActivated("lots_switch_checkbox");
    if (property_has_lots){
        lots_params_container.style.display = "block";
    }
    else{
        lots_params_container.style.display = "none";
    }
};

// Checkboxes :

function mapCheckBoxStateToNumber(checkbox_id){
    checkbox = document.getElementById(checkbox_id);
    if (checkbox.checked){
        number = 1;
    }
    else {
        number = 0;
    };
    return number
};

// Predict price :
let predict_price_button = document.getElementById("predict_price_button");

// Model prediction results : 
let model_prediction_label = document.getElementById("model_prediction_label");
let model_prediction_value = document.getElementById("model_prediction_value");

predict_price_button.onclick = function(){    
    current_address = address_input.value;
    living_surface = metric_living_surface_slider.value;
    number_of_rooms = metric_rooms_slider.value;
    number_of_lots = metric_n_lots_slider.value;
    has_lots = CheckboxIsActivated("lots_switch_checkbox");//mapCheckBoxStateToNumber("lots_switch_checkbox");
 
    front_parameters = {
        "current_address": current_address,
        "living_surface": living_surface,
        "number_of_rooms": number_of_rooms,
        "has_lots": has_lots,
        "number_of_lots": number_of_lots,
    }
    
    console.log(`Front parameters are : ${JSON.stringify(front_parameters)}`)
    
    updateAppFeatures(front_parameters)
};
 
$(function() {
    $('.ui.dropdown').dropdown;
});


function updateAppFeatures(front_parameters){
    let config_datasets = []
    $.ajax({
        type: "POST",
        method: "POST",
        url: getWebAppBackendUrl('send_app_features')+'/',
        data: JSON.stringify(front_parameters),
        dataType:"json",
        success: function(backend_response){
            // MAP MANAGEMENT : 
            address_successfully_geocoded = backend_response["geocoding_response"]["address_successfully_geocoded"]
            if (address_successfully_geocoded){
                geocoding_issue.innerHTML = ""
                address_geojson = backend_response["geocoding_response"]["address_geojson"];
                address_latitude = backend_response["geocoding_response"]["address_latitude"];
                address_longitude = backend_response["geocoding_response"]["address_longitude"];
                property_price_prediction = backend_response["property_price_prediction"];
                ///*
                map_layers.clearLayers();
                geojson = L.geoJson(address_geojson, {
                        style: {
                            "color": "#d96459",
                            "weight": 1,
                            "opacity": 0.9}
                    });
                map_layers.addLayer(geojson);
                map.panTo(new L.LatLng(address_latitude, address_longitude));
            }
            else {
                geocoding_issue.innerHTML = " Geocoding failure ! Please try another address"
                
            };
            model_prediction_label.style.display = "block";
            model_prediction_value.style.display = "block";
            
            model_prediction_value.innerHTML = property_price_prediction;
  
    }});
}


function GetCheckbox(checkbox_id){
    return document.getElementById(checkbox_id);
};


function CheckboxIsActivated(checkbox_id){
    let checkbox = GetCheckbox(checkbox_id);
    return checkbox.checked;
}

function LoadFirstDisplay(){
    lots_params_container.style.display = "none";
    model_prediction_label.style.display = "none";
    model_prediction_value.style.display = "none";
}
LoadFirstDisplay();

// Helpers : 
let collapsible_elements = document.getElementsByClassName("collapsible");
let i;

for (i = 0; i < collapsible_elements.length; i++) {
  collapsible_elements[i].addEventListener("click", function() {
    this.classList.toggle("active");
    var content = this.nextElementSibling;
    if (content.style.display === "block") {
      content.style.display = "none";
    } else {
      content.style.display = "block";
    }
  });
}

let application_title_button = document.getElementById("application_title_button");
let app_presentation_container = document.getElementById("app_presentation_container");
let app_helpers_containers = document.getElementById("app_helpers_containers");

function LoadHelpers(){
    application_title_button.className = "collapsible active";
    app_presentation_container.style.display = "block";
    app_helpers_containers.style.display = "none";
}

LoadHelpers();
$.getJSON(getWebAppBackendUrl('/first_api_call'), function(data) {
    console.log('Received data from backend', data)
    const output = $('<pre />').text('Backend reply: ' + JSON.stringify(data));
    $('body').append(output)
});