# Flow zone presentation
 
The [time_feature_engineering](flow_zone:5cpRaOZ) zone is responsible for applying time-based feature engineering to the properties' sales history.
 
![properties-time-feature-engineering.png](mSkNWKjgq6zo)
 
Among the main factor responsible that can lead to a property price, we have: 
- Its characteristics: this information is available at the beginning of the project.
- Its location context: this information is retrieved with the [properties_geospatial_enrichment zone](flow_zone:Uam9udZ)).
- Its time context <-> the real estate market at the time of the price estimate.
 
This is the latter piece of information that we want to compute here, before training a machine learning model.
 
Recipe [compute_properties_with_geospatial_features_windows](recipe:compute_properties_with_geospatial_features_windows) applies windows to the data looking, looking for the average square meter price: 
- At different locations, from micro to more macro locations: around each subway station, within each census polygon and each Paris district.
- On different periods in the past, from more recent to older: 30 days, 60 days, 90 days and 180 days in the past.
 
Combining these two pieces of information helps to bring different perspectives of the square meter price context around each property at the time of the price prediction.
 
 
Recipe [compute_properties_windows_prepared](recipe:compute_properties_windows_prepared) is in charge of filling in the missing values in the columns resulting from the Windows computation. To do this, each missing value is replaced by the closest available in the past (for example, if the average *last 30 days square meter price in a given district* is missing, we replace it with the *last 60 days square meter price of the same district*: if this one is missing, we look for the *last 90 days*, then *last 180 days* values).
 
Having the information of the last **T** days average square meter price, we also create here price estimates for each time frame **T** and location **L** that are: 
```T days average square meter price in L``` **X** ```property_living_surface``` .