# Slide presentation

This slide helps analyze the Paris subway network and the features we extracted from it after we projected it into a graph. [Learn more about graph analytics](article:32)

![subway-stations-analysis.png](w6TqYLY13Zb4)

# Slide charts

## Paris subway line stations

This first chart helps in understanding how the Paris subway network lines are organized.
![paris-subway-stations.png](5YMWY1MTSISF)

The next charts represent the same subway stations but with features coming from the graph we projected it into.

## Subway stations by number of connections (degree)

You can see here stations according to their number of connections (or "degree centrality"). The higher (resp. "lower") the degree centrality, the more (resp. "less") stations have connections with others.

![subway-stations-by-connections.png](sctzk5Tlyvxv)

## Subway stations by closeness (closeness centrality)

You can see here stations according to their closeness centrality.
[According to neo4j](https://neo4j.com/docs/graph-data-science/current/algorithms/closeness-centrality/) : 
> Closeness centrality is a way of detecting nodes that can spread information very efficiently through a graph.
The closeness centrality of a node measures its average farness (inverse distance) to all other nodes. Nodes with a high closeness score have the shortest distances to all other nodes.

In our context, the closeness centrality tells us how much each station helps in reaching any other destination of the subway network. You can see on the chart that this centrality smoothly decreases from the city center to most peripheral Paris areas.

![subway-stations-by-closeness.png](6e9so7N8HdVT)


## Subway stations by importance/influence (eigenvector centrality)

You can see here stations according to their eigenvector centrality.
[According to neo4j](https://neo4j.com/docs/graph-data-science/current/algorithms/eigenvector-centrality/) : 
>Eigenvector Centrality is an algorithm that measures the transitive influence of nodes. Relationships originating from high-scoring nodes contribute more to the score of a node than connections from low-scoring nodes. A high eigenvector score means that a node is connected to many nodes that themselves have high scores.

In our context, the eigenvector centrality tells us how much a subway station acts as both a hub and a hub close to other hubs. You can see on the chart that this centrality is highly concentrated on Paris center and then decreases fast as long as we move away from it.

![subway-stations-by-influence.png](PNGJDajkJzgR)