# Reconciliation Solution

This repo contains the code for reconciliation webapp.
The code is based on python for backend and Vue3 for the frontend.

The webapp uses Business solutions infra `webaiku` : https://github.com/dataiku/solutions-contrib.
You can find more information on what version is used inside `requirements.txt`.

It uses also `Business solutions UI components` library : https://github.com/dataiku/solutions-ui-components.
You can find the version in `deps.json` file.

## Local development

First check if you have `.env` file. If not create one. It should contain:

```
VITE_API_PORT="5000"
VITE_CLIENT_PORT="4200"
DKU_CURRENT_PROJECT_KEY="YOUR_DSS_PROJECT_KEY"
```

### Frontend

The web application is built on Node.js and utilizes the Quasar framework.

-   First, install the dependencies:
    `yarn install`
-   Then, run the local server:
    `yarn run dev`

### Backend

The backend is powered by Flask.

-   First, create your virtual environment:
    `python3 -m venv .your_venv_name`

-   Second, activate your virtual environment:
    `source .your_venv_name/bin/activate`
-   Third, install the required packages:
    `pip3 install -r requirements.txt`
-   Finally, run your local Flask server:
    ` python3 -m backend.wsgi`

## Deployment

To publish your webapp in production :

-   First build your webapp
    `yarn run build`
-   Go to your production instance and fetch the webapp git repo into libraries
-   Create a new standard webapp
-   Remove all the code in the generated html, css, js, python files.
-   Add below code instead:
    In the JavaScript tab of your web application, paste the following code:

```js
const backendURL = dataiku.getWebAppBackendUrl(
    "fetch/bs_init?URL=" + getWebAppBackendUrl("")
);
window.onload = function () {
    var ifrm = document.createElement("iframe");
    ifrm.setAttribute("src", backendURL);
    ifrm.setAttribute(
        "style",
        "position:fixed; top:0; left:0; bottom:0; right:0; width:100%; height:100%; border:none; margin:0; padding:0; overflow:hidden; z-index:999999;"
    );
    document.body.appendChild(ifrm);
};
```

Then add this code the the python part of the webapp

```python
from flask import Flask
from webaiku.extension import WEBAIKU
from {__YOUR_WEBAPPLICATION_FOLDER__}.backend.fetch_api import fetch_api


WEBAIKU(app, "webapps/{__YOUR_WEBAPPLICATION_FOLDER__}/dist")
WEBAIKU.extend(app, [fetch_api])
```

NB : The webapps work on container mode and local mode. you can set a special code env for backend execution if you use packages that are not included in the default dss env.
