import {
  Quasar,
  Notify,
  Loading,
  ClosePopup,
  QIcon,
  QMenu,
  QList,
  QItemSection,
  QItem,
  QCard,
  QCardSection,
  QItemLabel,
} from "quasar";
import "@quasar/extras/material-icons/material-icons.css";
import "@quasar/extras/material-icons-outlined/material-icons-outlined.css";
import "@quasar/extras/material-icons-round/material-icons-round.css";
import "@quasar/extras/mdi-v6/mdi-v6.css";
import "quasar/src/css/index.sass";
import "ag-grid-community/styles/ag-grid.css";
import "ag-grid-community/styles/ag-theme-alpine.css";
import "quasar-ui-bs/dist/style.css";
import "./fonts/fonts.scss";
import "vite/modulepreload-polyfill";

// 1. Import createPinia
import { createPinia } from 'pinia'; // <-- ADD THIS

import { QuasarBs } from "quasar-ui-bs";
import { myApp } from "./src/index";
import { ServerApi } from "quasar-ui-bs";
import { baseURL } from "./src/api/index";
//import router from "./src/router";  // <-- Import your router here

ServerApi.init(baseURL);
myApp.config.unwrapInjectedRef = true;

// 2. Create the Pinia instance
const pinia = createPinia(); // <-- ADD THIS

myApp.use(Quasar, {
  plugins: {
    Notify,Loading
  },
  components: {
    QIcon,
    QMenu,
    QList,
    QItemSection,
    QItem,
    QCard,
    QCardSection,
    QItemLabel,
  },
  directives: {
    ClosePopup,
  },
});

myApp.use(QuasarBs);

// 3. Tell your Vue app to use Pinia
myApp.use(pinia); // <-- ADD THIS

//myApp.use(router);  // <-- Use the router in your Vue instance

myApp.mount("#app");