import axios from "./api/index";

interface HelloResponse {
    key: string;
}

interface MatchesNbrResponse {
    manual: number; 
    pending: number;
}

interface PrimaryIdNameResponse {
    primary_id_name: string;
}

interface SecondaryIdNameResponse {
    secondary_id_name: string;
}

interface IdListResponse {
    id_list: string[];
}

interface IdOccurencesResponse {
    id_occurrences: { [key: string]: number };
}

interface KeysInfosResponse {
    primary_keys: string[]; 
    secondary_keys: string[]; 
    key_types: string[];
    thresholds: string[];
    weights: string[];
}

interface SaveSelectedIdPayload {
    selectedId: string;
}

interface SaveSelectedIdResponse {
    message: string;
}

// Add an interface for the filtered dataset response (update based on your dataset structure)
interface FilteredDatasetResponse {
    data: { [key: string]: any }[];  // Update this based on the structure of your filtered data
}

interface ExtraColsResponse {
    extra_cols_primary: string[]; 
    extra_cols_secondary: string[];
}

interface CellValueChangePayload {
    oldvalue: any;
    newvalue: any;
    celltype: string;
    primary_id: string;
    secondary_id: string;
}

interface CellValueChangeResponse {
    message: string;
}

// Added interface for the new endpoint
interface ReconciliationTypeResponse {
    reconciliation_type: string;
}

export let API = {
    //getHello: () => axios.get<HelloResponse>("/api/hello"),
    //getMatchesNumber: () => axios.get<MatchesNbrResponse>("/api/matches_nbs"),
    getPrimaryIdName: () => axios.get<PrimaryIdNameResponse>("/api/primary_id_name"),
    getSecondaryIdName: () => axios.get<SecondaryIdNameResponse>("/api/secondary_id_name"),
    getIdList: () => axios.get<IdListResponse>("/api/id_list"),
    getIdOccurences: () => axios.get<IdOccurencesResponse>("/api/id_occurrences"),
    getKeysInfos: () => axios.get<KeysInfosResponse>("/api/keys_info"),
    getFilteredData: (selectedId:string) => axios.get<SaveSelectedIdResponse>(`/api/save_selected_id/${selectedId}`),
    postTable: (payload: any) => axios.post<HelloResponse>("/bs_api/dataset/get_filtered_dataset", payload),
    getExtraCols: () => axios.get<ExtraColsResponse>("/api/extra_cols"),
    // Added method for the new endpoint
    getReconciliationType: () => axios.get<ReconciliationTypeResponse>("/api/reconciliation_type"),
    postCellValueChange: (payload: CellValueChangePayload) => 
        axios.post<CellValueChangeResponse>("/api/cell_value_change", payload),
}