<span id="version" style="color: grey; float: right">Version 2.0.0</span>
# Reconciliation

Organizations across various industries often face reconciliation challenges, particularly when matching and verifying data between multiple datasets. These challenges are frequently managed using Excel spreadsheets, but this approach can be improved and made more robust through the use of Dataiku.

The Reconciliation Solution offers a range of matching capabilities. The solution provides several methods to execute this, including perfect join for exact matches, fuzzy join based on customizable criteria, and access to a web application for manual matching.

Users can select the appropriate reconciliation type, choosing between 1-to-1 or 1-to-many matching. 

This combination of automated and manual methods ensures a comprehensive and flexible reconciliation process.

## Steps to follow to use this solution

1. Prepare your data in the right format following the [Data Model](article:12) article. 
2. Use the [Project Setup](article:6) interface to replace the demo data and setup your own version. 
3. Explore your own results in the [Dashboards](article:7).  

## Differences between  1-to-1  and  1-to-many  matching:

Users can select the appropriate reconciliation type, choosing between 1-to-1 or 1-to-many matching. In both cases, all rows in the secondary dataset are accounted for. They are either Perfect Matches, Automatic Matches, Pending Matches, Manual Matches, or No Match.
-  **One-to-one** : No rows from the primary or secondary datasets are duplicated.
-  **One-to-many** : Rows from the primary dataset can be duplicated if matched multiple times to different secondary observations.

Based on user selection, the flow and the web app behavior will adjust automatically (a lot of work was put into project automation with scenarios and web app interactivity).
-  **Flow** : flow zones Automatic Matching 1-to-many and Automatic Matching 1-to-1 will be built/cleaned accordingly
-  **Webapp** :
  -  **One-to-one** : If a match is approved manually in the webapp, other potential matches for the same primary or secondary observation are automatically set as rejected. Only one match is allowed by primary_id or secondary_id.
  -  **One-to-many** : If an observation from the secondary dataset is set as a match, then if the same observation is present somewhere else in the web app, it is set as rejected. However, the user can still unselect it and overwrite the previous selection.

## Reconciliation Process Schemas

### 1-to-1 Process
![Screenshot 2025-11-17 at 15.56.57.png](baAmxQiLA9ET)
### 1-to-many Process
![Screenshot 2025-11-17 at 15.57.11.png](hq4hjb9Oy6qF)

## Key Outcomes

### Reconciliation Analysis Dashboard

![Screenshot 2025-11-17 at 16.00.17.png](bDTpUZWZfYVF)

### Manual Matching Webapp - Focus Table 

![Screenshot 2024-12-11 at 17.55.47.png](3tTX5VagN5tm)

### Manual Matching Webapp - Full Table 

![Screenshot 2024-12-11 at 17.56.12.png](krWa0jSVx021)