This case study provides a detailed walkthrough of the solution using manually generated bank client data.

## User Story

The objective is to reconcile two datasets containing similar, but not identical, information. 

Specifically, we focus on matching four key columns: the credit card number , the country code, the date of birth, and the number of transactions recorded.

We want to perform a  **1-to-many**  reconciliation, meaning that rows from the primary dataset can be duplicated if matched multiple times to different secondary observations.

## Data

![Screenshot 2024-12-05 at 11.27.27.png](Y2FnCOthyv6v)

The key columns in both datasets share the same data types but may have different names (e.g., "country" in the primary dataset versus "country_code" in the other). Additionally, the input datasets may include extra columns or ID fields.

For detailed guidance on preparing the data, please refer to the accompanying [data model](article:12) article.

## Insights

With this solution, once the reconciliation process is implemented, a detailed analysis of the identified matches becomes available. Additionally, a web application will facilitate the manual review of pending matches and enable refreshing of the reconciliation analysis dashboard.

[Reconciliation Analysis Dashboard](dashboard:aRLxNwn)
[Manual Matching Webapp](web_app:oKmxgwi)


