To configure and execute the process, we will follow the steps in the [Project Setup](article:6).

The case study data is already in filesystem format, so we can skip the upload or connection steps and move straight to the reconciliation parameters. If you're using your data, you'll need to upload or connect it before proceeding.

## ID Columns

The first section to configure is the ID Columns section. It is necessary to decide whether to use existing ID columns or let the system generate them automatically. In this case, ID columns from both datasets will be included by selecting their names ( **ref_id**  and  **account_id** ) from the dropdown buttons.

![Screenshot 2024-12-05 at 11.49.33.png](WJpkLP7n0zmV)

## Columns Matching

Next, the corresponding columns (referred to as keys) from each dataset need to be selected for matching. The current version of the project supports up to fifteen keys. In this case, four keys will be defined.

![Screenshot 2024-12-05 at 13.15.53.png](BgREfRqtAcFZ)

For each pair of keys, we need to specify the  **data type** : numeric, string, or date. 
- credit card number:  **string**  
- country code:  **string** 
- date of birth:  **date** 
- number of transactions:  **numeric** 

We also need to set a  **matching distance threshold**  to define the acceptable level of dissimilarity between values in the key columns. These thresholds will be used in the fuzzy join step. 
- credit card number:  **0** -> values must perfectly match. 
- country code:  **2** -> maximum of 2 edits—insertions, deletions, or replacements— to transform one string into another.
- date of birth:  **1036800** -> maximum of 12 days difference.
- number of transactions:  **10** -> maximum of 10 transactions difference. 

Finally, we can adjust the  **weights of each key**  to influence their importance in the overall match score calculation. In our case we want all keys to have equal importance so we keep the default value of  **1** . 

Once the keys are defined, the user must validate inputs and generate the Data Sanity Check Dashboard by clicking on the  **Run button** .

The [Data Sanity Check](dashboard:Wz5zOex) Dashboard can be used to verify the quality of the keys that were selected in the Project Setup.

![Screenshot 2024-12-05 at 13.18.07.png](kZZubZbXAJaj)

## Extra Columns 

In the next section, extra columns can be selected (if any) that are not part of the keys but are important for display in the manual matching web app and final results. These columns provide additional context and assist in the decision-making process.

![Screenshot 2024-12-05 at 13.19.03.png](3dyv2k7LXrWf)

In this case, one additional column was selected from each dataset:  **card_type**  from the primary dataset and  **last_name**  from the secondary dataset. 

## Automatic Matching

Then, we can establish an  **automatic matching threshold**  along with a  **maximum limit for potential matches** .

![Screenshot 2024-12-05 at 13.25.20.png](MSoWuwBTmgEg)

The threshold selected in this case is  **75%** , with a maximum of  **3**  potential matches. This means that all observations with a match score above 75% (but below 100%) will be  considered as Automatic Matches. If a primary observation has multiple automatic matches, only the one with the highest score is retained. Additionally, in the fuzzy join process, if a primary observation is matched multiple times with scores below the 75% threshold, only the top 3 matches for each observation will be retained.

## Reconciliation

In the last section, we need to select the type of reconciliation you would like to perform, in our case 1-to-many. Then, we can build the flow and generate reconciliation results by clicking on the  **Run button** . 

![Screenshot 2025-11-17 at 16.24.25.png](EEie7TSEvnzx)
When the project is finished being built, we can access the [Reconciliation Analysis](dashboard:aRLxNwn) dashboard and the [Manual Matching](dashboard:YDJefbh) webapp.  

## Reconciliation Analysis Dashboard - Before Manual Review

The  [Reconciliation Analysis](dashboard:aRLxNwn) provides an overview of how records are categorized based on their alignment with the secondary dataset. Records may fall into one of several match types: perfect, automatic, pending, manual, or no match.

![Screenshot 2025-11-17 at 16.24.39.png](HLZjkh5dv6A5)
On the first run, we can observe that there are no manual matches. This is because all potential manual matches have not yet been flagged manually and are still classified as pending matches.

In this case, 12% of the records are classified as perfect matches, while 10% are classified as automatic matches. These will not be impacted by further manual reviews. 

![Screenshot 2025-11-17 at 16.27.43.png](rYOmLUsPgtpu)
Perfect matches are the matches with a 100% match score, meaning that the distances between the different pairs of keys are equal to 0. Automatic matches refer to those matches whose match scores exceeded the user-set Automatic Matching Threshold, yet fell short of a perfect 100%.

## Manual Matching Webapp

The manual matching web app enables the manual approval or rejection of pending matches. It offers the option to review each match individually (focus table) or through a more comprehensive view (full table).

![Screenshot 2025-11-17 at 16.51.43.png](YWybWUQvbnpr)
In the Focus Table tab, the ID from the primary dataset can be selected for review (e.g., 04baa4) either by using the dropdown menu or by typing the ID directly. The page will update dynamically based on the selected ID. Then we can use the dropdown button to flag matches and insert comments if necessary.

![Screenshot 2025-11-17 at 16.52.52.png](hxLHoWD6wof7)
In the Full Table tab, users can scroll down to view more matches and click the button in the bottom right to navigate to the next page if needed. If multiple potential matches exist, the observations are grouped together by the primary ID column.

Using one or both tabs, matches can be manually flagged as Approved, Rejected, or Pending. Additionally, users can enter comments to provide more context or information regarding these decisions.

![Screenshot 2024-12-05 at 14.32.03.png](yMdexk26rsW5)

![Screenshot 2024-12-05 at 14.33.33.png](o7XR7jr0VbmD)

## Reconciliation Analysis Dashboard - After Manual Review

To update the reconciliation analysis and include the reviews made in the manual matching web app, we simply need to click the Update Analysis button, wait a few seconds, and refresh the page. 

![Screenshot 2025-11-17 at 18.27.46.png](CwejsWLC9Hlf)
Following our manual input in the web app, we can see that some matches are now classified as manual matches. To view details about these matches, we can go to the Manual Matches section. 

![Screenshot 2025-11-17 at 18.28.04.png](gygWXcjqaWdP)
We can also see if any matches were manually rejected in the No Match section of the dashboard.

![Screenshot 2025-11-17 at 18.28.13.png](ajISl4Tp4Io3)