The  **Project Setup**  allows users to customize parameters and use the solution with their own data through a visual interface. To make further adjustments to the project, the users still have the ability to go into the flow to  update parameters directly. 

To access the Project Setup interface, navigate to the project's homepage by clicking on the project name, then select "Project Setup."

![Screenshot 2024-12-03 at 14.41.27.png](FFr4sEJIYfSx)

## Data update disclaimer 
Before beginning the Project Setup, users should read the disclaimer carefully. They have two options to replace the demo datasets with new data: uploading data from a computer OR connecting to a database.

![Screenshot 2024-12-03 at 14.44.26.png](zGEgUmu4zKuz)

## Option 1 - Data upload

To refresh the project with new data, users can delete the existing datasets by clicking on the trash icon next to their name and then upload new files by dragging and dropping them or by clicking the "add a file" button.

![Screenshot 2024-12-03 at 14.46.12.png](QyzOWoS4l01S)

After updating the datasets in the interface, users must press "run" to initiate the scenario, which will load the data, clear project variables, and build sync recipes. 

## Option 2 - Data connection 

To update the project with new data, the user can update the connection settings section by connecting to a database.

![Screenshot 2024-12-03 at 14.50.10.png](lWzyfN3NHNhm)

The project comes pre-configured with all datasets using the filesystem connection. The user can either keep this setup or change it to their preferred connection by modifying the connection settings section and clicking on "run" to reconfigure the flow connections. 

By clicking the blue links, the user will access the connection setting page and will be able to change the path to their datasets. 

![Screenshot 2024-12-03 at 10.42.18.png](zHUV5rIqQX0D)

It might be necessary to click on the "Reload Schema from Table" button to avoid errors in schema detection. 

After updating the datasets in the interface, users must press "check" to initiate the scenario, which will load the data and clear project variables. 

## ID Columns

In this section, the user can decide whether to use its own ID column(s) or allow the project to generate them automatically.

This section must be used only if at least one of the input datasets contains an ID column that needs to be included in the analysis. If one of the ID columns that should be used is named 'id'; it must be renamed before loading the data.

![Screenshot 2024-12-03 at 14.58.19.png](tFx4DA5vxjIy)

## Columns Matching

In this section, the corresponding columns (referred to as keys) from each dataset to be matched are selected. In the current version of the project, up to fifteen keys can be used.

![Screenshot 2024-12-03 at 15.34.45.png](nLbJyaFbf0Cj)

For each pair of keys, the data type must be specified as numeric, string, or date.

A matching distance threshold should also be set to define the acceptable level of dissimilarity between values in the key columns. These thresholds will be applied during the fuzzy join step.

Additionally, the weights of each key can be adjusted to influence their importance in the overall match score calculation.

Once the keys are defined, inputs must be validated, and the Data Sanity Check Dashboard can be generated by clicking the Run button.

The Data Sanity Check Dashboard can be used to verify the quality of the keys that were selected in the Project Setup. 

## Extra Columns

In the next section, users choose extra columns (if any) that aren't part of the keys but are still important for displaying in the manual matching web app and the final results, to help with decision-making.

![Screenshot 2024-12-03 at 15.36.25.png](wjn6LJUWor9D)

## Automatic Matching

This section allows to establish an automatic matching threshold along with a maximum limit for potential matches.

Automatic matches refer to those matches whose match scores exceeded the user-set Automatic Matching Threshold, yet fell short of a perfect 100%.

![Screenshot 2024-12-03 at 15.38.34.png](Czd4GSRl9ouZ)

## Reconciliation

The last section is where the reconciliation process is launched.

The user must select the type of reconciliation he would like to perform.

Once the scenario is run successfully, users can access the Reconciliation Analysis Dashboard and the Manual Matching Webapp.

![Screenshot 2025-11-17 at 16.09.09.png](4Fl0ttJITjxe)
