## Purpose of Scenarios in this Solution

Scenarios allow to automate the computation of the flow and are triggered through the Project Setup, the Dashboards or the Webapp.

Scenarios should only be modified by users with an advanced understanding of the project and the capability to interpret and adjust custom Python steps.

## Scenarios Explained

![Screenshot 2024-12-03 at 18.25.32.png](UVKeEfAO3Ava)

[01. Load Data - Upload](scenario:01LOADDATA): Once the datasets are uploaded, the data schema is verified, and sync recipes are built to update the input data in the flow.

(This scenario is used only if the user picks the Option-1 in the Project Setup)

[00. Reconfigure flow connections](scenario:00RECONFIGUREFLOWCONNECTIONS): All recipes' and datasets' connections are switched based on the selection made by the user in the project setup. Originally uploaded datasets and subsequent sync recipes are deleted from the flow.

(This scenario is used only if the user picks the Option-2 in the Project Setup)

[01. Load Data - Connection](scenario:01LOADDATACONNECTION): Once the links to the input datasets are updated by the user, the data schema is verified.

(This scenario is used only if the user picks the Option-2 in the Project Setup)

![Screenshot 2024-12-03 at 18.29.30.png](fBAvAQrgIWML)

[02. Prepare Data](scenario:02PREPAREDATA): Automation of the [Data Preparation](article:19) flow zone. 

[Check Inputs](scenario:03CHECKINPUTS): Automation of the [Data Sanity Check](article:20) flow zone. 

[On/Off Check Inputs Steps](scenario:03ONOFFCHECKINPUTSSTEPS): Turns on and off parts of the [Check Inputs](scenario:03CHECKINPUTS) scenario based on user input dataset. 

[03. Data Sanity Check](scenario:03DATASANITYCHECK): Runs both the [On/Off Check Inputs Steps](scenario:03ONOFFCHECKINPUTSSTEPS) and the [Check Inputs](scenario:03CHECKINPUTS) to build the [Data Sanity Check](article:20) flow zone correctly. 

![Screenshot 2025-11-18 at 11.08.15.png](wuJPUIEHcZFB)

Scenarios 4 to 8 automate their respective flow zones.

![Screenshot 2024-12-04 at 09.56.34.png](EPkk5BWFhUT3)

[09. Run All Matching](scenario:09RUNALLMATCHING): Used at the end of the project setup to run the reconciliation and build the whole flow. It also turns on/off flow zones based on the type of reconciliation selected by the user.  
![Screenshot 2025-11-18 at 11.10.04.png](HHmqxLrVvFxi)


![Screenshot 2024-12-04 at 09.56.42.png](118MJ4LjJjpj)

[10. Update Webapp Data](scenario:10UPDATEMATCHING): Launched automatically when modifications are made in the manual matching webapp. 

![Screenshot 2024-12-04 at 09.56.50.png](2jOUatRAqL3p)

[11. Update Results](scenario:11UPDATERESULTS): Updates the analysis in the reconciliation analysis dashboard based on the changes made in the manual matching webapp. 