# What is Drug Repurposing?

While the development of new chemical compounds and drugs is an important part of pharamecutical research, traditional research comes at a high cost - both in time and money. To speed up the development of new treatments, many researchers look at existing compounds to find previously unknown applications in modern medicine. Historically, this repurposing happens by pure chance, such as when doctors discover that hypertension medication also reduces nightmares in PTSD patients. However, in recent years, the industry has made a more concerted effort at discovering new links intentionally through the use of data analytics and developments in machine learning. In particular, researchers are turning to the use of network graphs, to uncover and predict connections between drugs and diseases.

# The Network Graph 

A network graph is a connection of nodes and edges, that maps the relationship among the data. In the world of drug repurposing, nodes and edges can take on many different forms - such as genes, disease, chemical compounds, mechanisms of action and more. Below is a metagraph of the drug repurposing network this project produces.

![image.png](QQBOIkp6jqYo)



# Challenges of Drug Repurposing

The use of AI to aid the research and development of new treatments from existing compounds is exciting, but not without it's own challenges. Numerous open source datasets on genes, diseases, chemical compounds and more support researchers in their efforts to discover new treatments. However, these sources are often updated as new information comes to light, meaning that the continual management and processing of this data is a necessary step. Moreover, joining multiple disparate datasets requires a common key to translate the various types of data involved in drug repurposing. Finally, the exploration and discovery of new links between different nodes of a network is predicated on computationally heavy algorithms. To successfully build a drug network graph, researchers need the right tools to extract, clean and analyse multiple forms of data.

# How Dataiku Can Help

In this project, you will see how Dataiku can access different sources of information from the research world, clean messy and complex data, and finally blend the numerous datasets for further network analysis. This project makes use of Dataiku's plugin for Neo4J, allowing you to quickly and seamlessly write new data to a graph database, from which analytics can be performed. Dataiku makes the process of building and maintaining a network graph for drug discovery seamless and transparent.
