# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu
from clusterOrdering import order_cluster

# Read recipe inputs
customers_train_with_CLV_frequency = dataiku.Dataset("frequency_raw_clusters")
customers_train_with_CLV_frequency_df = customers_train_with_CLV_frequency.get_dataframe()


# Compute recipe outputs from inputs
# TODO: Replace this part by your actual code that computes the output, as a Pandas dataframe
# NB: DSS also supports other kinds of APIs for reading and writing data. Please see doc.

customers_train_with_CLV_frequency_df = order_cluster('cluster_labels', 
                                                      'Frequency',
                                                      customers_train_with_CLV_frequency_df,
                                                      True)

customer_frequency_score_df = customers_train_with_CLV_frequency_df # For this sample code, simply copy input to output


# Write recipe outputs
customer_frequency_score = dataiku.Dataset("frequency_clusters")
customer_frequency_score.write_with_schema(customer_frequency_score_df)
