# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu
from clusterOrdering import order_cluster

# Read recipe inputs
customers_train_with_CLV_clustered_mv = dataiku.Dataset("monetary_value_raw_clusters")
customers_train_with_CLV_clustered_mv_df = customers_train_with_CLV_clustered_mv.get_dataframe()


# Compute recipe outputs from inputs
# TODO: Replace this part by your actual code that computes the output, as a Pandas dataframe
# NB: DSS also supports other kinds of APIs for reading and writing data. Please see doc.

customers_train_with_CLV_clustered_mv_df = order_cluster('cluster_labels',
                                                          'MonetaryValue',
                                                          customers_train_with_CLV_clustered_mv_df,
                                                          True)

customer_mv_score_df = customers_train_with_CLV_clustered_mv_df # For this sample code, simply copy input to output


# Write recipe outputs
customer_mv_score = dataiku.Dataset("monetary_value_clusters")
customer_mv_score.write_with_schema(customer_mv_score_df)