# 背景
顧客生涯価値（CLV）は、既存顧客が特定の期間内に生み出すことのできる潜在的な「価値」を示すものです。CLV を予測することで、顧客の購入行動に関する詳しいインサイトを手にすることができるため、より正確なビジネスの数値化が可能となります。このソリューションの使用方法について詳しくは、 [ナレッジベース](https://knowledge.dataiku.com/latest/kb/industry-solutions/rfm-customer-lifetime-value/rfm-customer-lifetime-value.html)をご覧ください。

# プロジェクトの目的
このソリューションの主な目的は、既知の取引履歴を持つ既存顧客の、将来の特定の期間における CLV を予測するとともに、RFM スコアによるエンリッチ化を通してより高い予測精度を実現することです。

この顧客生涯価値ソリューションは、以下のような全体を通したエンドツーエンドのパイプラインを含むテンプレートプロジェクトソリューションです。
- データの前処理
- RFM スコアの計算
- さまざまな手法によるすべての顧客の CLV の予測
- 顧客のセグメント化とクラスタリング
- 商品分析の提供
- インサイトの取得に役立つ KPI を可視化するダッシュボードの更新

このプロジェクトの主なステップの詳細説明については、[フローセクション](article:4)をご覧ください。
 
 
# プロジェクトの価値
このプロジェクトはいくつかのニーズに対応しています。
 
- 小売業の**マーケティング・アナリスト**として、新しいマーケティング・キャンペーンを企画する際に、顧客ごとにRFMスコアとCLV予測を計算し、どの顧客をターゲットにすればよいかを把握したい。
 
- **小売業のビジネスアナリスト**として、販売戦略を策定する際に、顧客獲得にどれだけ投資するかを計画できるように、全顧客のCLV予測レポートを作成したい。
 
-  **小売ビジネスアナリスト**として、顧客アウトリーチのアプローチを実行する際に、顧客がアクティブである確率を計算し、アクティブな顧客と非アクティブな顧客を区別できるようにしたい。

- **小売業アナリスト**として、現在の顧客ベースを分析する際に、取引履歴データセット、顧客情報、商品説明データセットを入力し、各顧客のRFMスコアを受け取ることで、顧客がもたらす価値についてより明確に理解できるようにしたいです。
 
 
# このプロジェクトの開始方法

1.  [こちら](article:14)の説明に従って、プロジェクト変数を更新します。
2. 自社の取引データセットを使用して、入力データセット[transactions_dataset](dataset:transactions_history) の内容を変更します。
3. 使用する接続に合わせて、フロー内のすべてのデータセットの接続を変更します。
4. 入力データセットのスキーマが [要件のセクション](article:3)の説明と合わない場合は、フロー全体に新しいスキーマを反映させることもできます。
5. すべてのフローを構築します。