![Screen Shot 2022-02-24 at 3.56.12 PM.png](IDC0aBhmy1A2)

このフローゾーンでは、RFM スコアの計算を行います。

CLV モデルへの 3 つの重要な入力として、リーセンシー、購入頻度、購入金額があります。
 
- （R）リーセンシー：顧客の最初の注文に対して最後の注文はいつだったか
- （F）購入頻度：顧客はどの程度の頻度で購入しているか
- （M）購入金額：顧客が支出する金額は平均でいくらか
- マーケティングリーセンシー：顧客が最後に購入してから基準日までの期間はどの程度か
 
>  :warning:  リーセンシーには 2 つの定義があるので注意が必要です
> - 統計的リーセンシー（このプロジェクトでは「リーセンシー」と呼びます）
> - マーケティングリーセンシー（このプロジェクトでは「マーケティングリーセンシー」と呼びます）
 
このフローゾーンでは、各変数の値に基づき、各顧客のリーセンシー、マーケティングリーセンシー、購入頻度、購入金額のスコアを計算します。

# セグメンテーション（Segmentation）

これらのスコアをもとに、自動で顧客をセグメント化します。この目的を達成するために、2つのオプションが考えられます

- 分位数：顧客は各スコアリング・カテゴリーに均等に分けられます。仮に5つのカテゴリーを選択した場合、各カテゴリーには総顧客数の5分の1ずつが含まれることになります。この方法の利点は、カテゴリの母集団がバランスよく配置されることですが、逆に欠点は、あるカテゴリから次のカテゴリへの境界線が恣意的に見え、非常に近いスコアを持つ顧客が別々のカテゴリに配置される可能性があることです。
- クラスタリング: 教師なし機械学習の一種で、類似した観察結果をグループ化することを目的としています。それは、セグメンテーションが正しいか間違っているかを評価するためのラベルがないという意味で教師なしとされています。多くのアルゴリズムがこのクラスタリングを実行するためにVisual MLで利用可能ですが、Dataikuの場合、シンプルなKmeansクラスタリングを選択しています。

Kmeansを使用すると、作成したいクラスタの数を入力とし、大きさは均等ではないが、より均質で、より解釈しやすいカテゴリを出力します。

# スコアリング（Scoring）

そのために、リーセンシー、マーケティングリーセンシー、購入頻度、購入金額のうち、一度に 1 つの変数のみを使用して、クラスタリングアルゴリズム（k 平均法）のトレーニングを 4 回行います。その後、リンクされている変数の値に従ってクラスターを並べ替え、クラスターをスコアに変換します。変位値を使用して、リーセンシー、マーケティングリーセンシー、購入頻度、購入金額のスコアを構築することもできます。この処理は、4 つの［Python］レシピで行われます。最後に、3 つのスコアの合計を計算して最終的なスコアを求めます。RFM スコアの場合はリーセンシーを、マーケティング RFM スコアの場合はマーケティングリーセンシーを使用します。
RFM スコア上位の顧客を取得するために、このフローゾーンの最後で [TopN （上位N）レシピ](recipe:compute_customers_rfm_score_topn)を使用します.