# Flow zone presentation

The [RFM computation Preprocessing](flow_zone:mVAdv0W) is dedicated to aggregating the transaction data at the customer granularity so that we get the features that are used to compute the RFM information. It has a focus on all the transactions that have been done in the period defined with the [dates filtering strategy](article:43). 

![rfm_computation_preprocessing.png](jido1wDlG1r4)

- Recipe [compute_transactions_rfm_filtered_dates](recipe:compute_transactions_rfm_filtered_dates) filters the transactions data on transactions respecting your [dates filtering strategy](article:43).

- Recipe [compute_customer_baskets](recipe:compute_customer_baskets) aggregates the data at the **customer_id** x **transaction_id** granularity so that we can have the information of:
  - The total of the customer transactions basket.
  - The total number of items purchased in customer transactions.
  
- Recipe [compute_customer_purchasing_actions](recipe:compute_customer_purchasing_actions) aggregates the data at the **customer_id** granularity so that we can have the information of:
  - The "first" and "last" purchase dates. 
      - Later, the difference between the transactions reference date ([See transactions_preprocessing](article:27)) and the "last purchase date" will allow computing the feature "days_since_last_transaction", which will then be used to learn and apply the **R**ecency scoring. 
      - The difference between "last" and "first" purchase dates will lead to the "days_between_first_and_last_transaction" that can then be used for further analysis or data enrichment.
  - The count of transactions done by each customer: this feature will be used to learn and apply the **F**requency scoring.
  - The average and the sum of customer baskets: depending on the *monetary value policy* ([See RFM](article:39)) one or the other will be used to learn and apply the **M**onetary value scoring.
  - The average and the sum of the number of items purchased by customers: similarly, one or the other will be used depending on the *monetary value policy* to learn and apply the **D**ensity scoring ([What is this "Density" ?](article:13)).

- Recipe [compute_customer_rfm_inputs](recipe:compute_customer_rfm_inputs) finally computes the differences between dates described before. 